/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.dee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.distro.tech.yigosupport.extension.dee.impl.DTSUtils;
import com.bokesoft.distro.tech.yigosupport.extension.dee.impl.JSONUtils;
import com.bokesoft.distro.tech.yigosupport.extension.dee.impl.NodeItr;
import com.bokesoft.yes.dts.DataTransferService;
import com.bokesoft.yes.dts.data.DTSDataProvider;
import com.bokesoft.yes.dts.data.IDTSDataProvider;
import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DeeImporter {
    private JSONArray data = new JSONArray();

    private DeeImporter() {
    }

    public static DeeImporter fromJSONArray(JSONArray data) {
        DeeImporter di = new DeeImporter();
        di.data = data;
        return di;
    }

    public static DeeImporter fromJSONObject(JSONObject json) {
        DeeImporter di = new DeeImporter();
        JSONArray data = new JSONArray();
        data.add((Object)json);
        di.data = data;
        return di;
    }

    public static <T> DeeImporter fromList(List<T> list) {
        DeeImporter di = new DeeImporter();
        JSONArray data = new JSONArray();
        for (T o : list) {
            JSONObject json = (JSONObject)JSON.toJSON(o);
            data.add((Object)json);
        }
        di.data = data;
        return di;
    }

    public static DeeImporter fromObject(Object object) {
        JSONObject json = (JSONObject)JSON.toJSON((Object)object);
        return DeeImporter.fromJSONObject(json);
    }

    public JSONArray getData() {
        return this.data;
    }

    public DeeImporter renameNode(String parentJsonPath, final String oldNodeName, final String newNodeName) {
        JSONUtils.foreachJSONPath(this.data, parentJsonPath, new NodeItr(){

            @Override
            public void process(JSONObject node) {
                Object child = node.get((Object)oldNodeName);
                if (null != child) {
                    node.remove((Object)oldNodeName);
                    node.put(newNodeName, child);
                }
            }
        });
        return this;
    }

    public DeeImporter removeNode(String parentJsonPath, final String nodeName) {
        JSONUtils.foreachJSONPath(this.data, parentJsonPath, new NodeItr(){

            @Override
            public void process(JSONObject node) {
                node.remove((Object)nodeName);
            }
        });
        return this;
    }

    public DeeImporter aggregateAsJSONString(String parentJsonPath, final String nodeName) {
        JSONUtils.foreachJSONPath(this.data, parentJsonPath, new NodeItr(){

            @Override
            public void process(JSONObject node) {
                Object child = node.get((Object)nodeName);
                if (!(null == child || child instanceof Number || child instanceof String || child instanceof Date)) {
                    node.put(nodeName, (Object)JSON.toJSONString((Object)child));
                }
            }
        });
        return this;
    }

    public DeeImporter configThingName(String thingName) {
        DTSUtils.configHeader(this.data, "mule.adapter.thing-name", thingName);
        return this;
    }

    public DeeImporter configFormKey(String formKey) {
        DTSUtils.configHeader(this.data, "mule.adapter.formkey", formKey);
        return this;
    }

    public DeeImporter configOpPlan(OperationTypes opPlan) {
        String opName = DTSUtils.opPlan2Str(opPlan);
        return this.configOpPlan(opName);
    }

    public DeeImporter configOpPlan(String opPlanName) {
        DTSUtils.configHeader(this.data, "mule.adapter.op-plan", opPlanName);
        return this;
    }

    public DeeImporter configIdFields(String ... idFields) {
        String flds = StringUtils.join((Object[])idFields, (String)",");
        DTSUtils.configHeader(this.data, "mule.adapter.id-fields", flds);
        return this;
    }

    public DeeImporter configReturnFields(String ... field) {
        String fields = StringUtils.join((Object[])field, (String)",");
        DTSUtils.configHeader(this.data, "mule.adapter.return-fields", fields);
        return this;
    }

    public DeeImporter configAutoDeleteUnknownDetail(String ... tableKeys) {
        String tbls = StringUtils.join((Object[])tableKeys, (String)",");
        DTSUtils.configHeader(this.data, "mule.adapter.auto-delete-unknown-detail", tbls);
        return this;
    }

    public DeeImporter configDetailOpPlan(String tableName, OperationTypes opPlan) {
        String opName = DTSUtils.opPlan2Str(opPlan);
        return this.configDetailOpPlan(tableName, opName);
    }

    public DeeImporter configDetailOpPlan(String tableName, String opPlanName) {
        DTSUtils.configDetail(tableName, this.data, "mule.adapter.op-plan", opPlanName);
        return this;
    }

    public DeeImporter configDetailIdFields(String tableName, String ... idFields) {
        String flds = StringUtils.join((Object[])idFields, (String)",");
        DTSUtils.configDetail(tableName, this.data, "mule.adapter.id-fields", flds);
        return this;
    }

    public org.json.JSONArray importData(DefaultContext ctx) throws Throwable {
        return this._doImport(ctx, 1);
    }

    public org.json.JSONArray saveData(DefaultContext ctx) throws Throwable {
        return this._doImport(ctx, 0);
    }

    private org.json.JSONArray _doImport(DefaultContext ctx, int transType) throws Throwable {
        DTSDataProvider dtsDataBuilder = new DTSDataProvider();
        return (org.json.JSONArray)DataTransferService.multiDataTransfer((DefaultContext)ctx, (IDTSDataProvider)dtsDataBuilder, (String)this.data.toJSONString(), (int)transType);
    }

    public org.json.JSONArray callRemoteGateway(RawConnection conn) {
        String result = conn.post(this.data.toJSONString());
        return new org.json.JSONArray(result);
    }

    public static interface RawConnection {
        public String post(String var1);
    }
}

