package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.bokesoft.yigo.common.trace.TraceRecorder;

/**
 * yigo服务上下文基础结构VO
 */
public class BasicServiceVO {
    private static final String ARG_KEY_SERVICE = "service";
    private static final String ARG_KEY_CMD = "cmd";
    private static final String ARG_KEY_EXT_PARAS = "paras";

    /**
     * 服务名称
     */
    private String service;
    /**
     * 服务命令
     */
    private String serviceCmd;
    /**
     * 服务参数
     */
    private String serviceArgs;



    /**
     * 产生操作信息的系统身份
     */
    private String sysIdentity;

    /**
     * x-b3-traceid
     */
    private String traceId;
    /**
     * x-b3-spanid
     */
    private String spanId;
    /**
     * x-b3-parentspanid
     */
    private String parentSpanId;

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getServiceCmd() {
        return serviceCmd;
    }

    public void setServiceCmd(String serviceCmd) {
        this.serviceCmd = serviceCmd;
    }

    public String getServiceArgs() {
        return serviceArgs;
    }

    public void setServiceArgs(String serviceArgs) {
        this.serviceArgs = serviceArgs;
    }



    public void setSysIdentity(String sysIdentity) {
        this.sysIdentity = sysIdentity;
    }

    public String getSysIdentity() {
        return sysIdentity;
    }


    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getSpanId()    {
        return spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getParentSpanId() {
        return parentSpanId;
    }

    public void setParentSpanId(String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    /**
     * 从参数中选择一些典型的数据, 作为 paras 的补充
     */
    private static final String[] PARAM_REF_KEYS = new String[] { "oid", "itemKey", "itemData", "objectKey", "sql",
            "extSvrName", "OID", "key", "parameters" };

    public static BasicServiceVO build(Map<String, Object> args){
        BasicServiceVO vo=new BasicServiceVO();
        // FIXME - 目前 产生操作信息的系统身份 无法获取，统一写死
        vo.setSysIdentity("default");
        if (null != args.get(ARG_KEY_SERVICE)) {
            vo.setService((String) args.get(ARG_KEY_SERVICE));
        }
        if (null != args.get(ARG_KEY_CMD)) {
            vo.setServiceCmd((String) args.get(ARG_KEY_CMD));
        }
        Map<String, Object> paras = new HashMap<>();
        if (null != args.get(ARG_KEY_EXT_PARAS)) {
            paras.put("paras", args.get(ARG_KEY_EXT_PARAS));
        }

        Map<String, Object> refs = new HashMap<>();
        for (String key : PARAM_REF_KEYS) {
            Object v = args.get(key);
            if (null != v) {
                if (v instanceof String || v instanceof Number || v instanceof Date) {
                    refs.put(key, v);
                } else {
                    refs.put(key, JSON.toJSON(v));
                }
            }
        }
        if (refs.size() > 0) {
            paras.put("refs", refs);
        }

        vo.setServiceArgs(paras.toString());
        vo.setTraceId(TraceRecorder.getTraceId());
        vo.setSpanId(TraceRecorder.getSpanId());
        vo.setParentSpanId(TraceRecorder.getParentSpanId());
        return vo;
    }

    @Override
    public String toString() {
        return "BasicServiceVO{" +
                "service='" + service + '\'' +
                ", serviceCmd='" + serviceCmd + '\'' +
                ", serviceArgs='" + serviceArgs + '\'' +
                ", sysIdentity='" + sysIdentity + '\'' +
                ", traceId='" + traceId + '\'' +
                ", spanId='" + spanId + '\'' +
                ", parentSpanId='" + parentSpanId + '\'' +
                '}';
    }

}
