package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import org.apache.commons.lang3.exception.ExceptionUtils;

import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

/**
 * 用于两阶段导入（1-接口导入到中间表、2-中间表数据保存到业务表）
 */
public class TwoPhaseImportUtil {
	/** 中间表字段，CLOB 类型，用于存放错误信息 */
	private static final String FIELD_EX_ERROR_MESSAGE = "ex_error_message";
	/** 中间表字段，CLOB 类型，用于存放错误标识 */
	private static final String FIELD_EX_ERROR_FLAG = "ex_error_flag";
	/** {@link #FIELD_EX_ERROR_FLAG} 字段的值，表示没有错误 */
	private static final int ERROR_FLAG_NO_ERROR = 0;
	/** {@link #FIELD_EX_ERROR_FLAG} 字段的值，表示导入出现错误 */
	private static final int ERROR_FLAG_ERROR = 1;

	/**
	 * 记录导入数据错误
	 * @param e 错误信息，为空代表没有错误
	 * @param headTable 中间表的头表名称
	 * @param oid 中间表的记录 OID
	 */
	public static void recordExError(Throwable e, String headTable, long oid){
		SessionUtils.processWithContext(null, ctx -> {
			int errFlag = ERROR_FLAG_NO_ERROR;
			String errMsg = "";
			if(null != e){
				errFlag = ERROR_FLAG_ERROR;
				errMsg = e.getMessage()+"\n"+ExceptionUtils.getStackTrace(e);
			}
			
			int results = ctx.getDBManager().execPrepareUpdate(
					"UPDATE "+headTable
					+" SET "+FIELD_EX_ERROR_FLAG+"=?, "+FIELD_EX_ERROR_MESSAGE+"=?"
					+" WHERE OID=?", errFlag, errMsg, oid);
			
			if (results!=1) {
				throw new RuntimeException("接口导入状态错误 - 更新接口导入信息失败，更新记录数="+results);
			}
			
			return true;
		});
	}

	/**
	 * 从当前保存的接口表(source)查找到相应业务表(target)的OID, 然后加载或者创建业务表 Document
	 * @param context Yigo执行上下文，注意其中必须包括已经保存的接口表的 document
	 * @param srcHeadTable 接口表头表表名
	 * @param srcUidField 接口表头表中唯一标识字段的字段名
	 * @param tgtHeadTable 业务表头表表名
	 * @param tgtUidField 业务表头表中唯一标识字段的字段名
	 * @param tgtDataObjectKey 业务表的数据对象名
	 * @return 如果根据 接口表头表中唯一标识字段 可以找到 业务表 记录, 加载对应的 Document, 否则创建新的 Document
	 * @throws Throwable
	 */
	public static Document buildTargetDocumentFromSavedSource(DefaultContext context, String srcHeadTable, String srcUidField,
			String tgtHeadTable, String tgtUidField, String tgtDataObjectKey) throws Throwable {
		Document doc = context.getDocument();
		
		DataTable h = doc.get(srcHeadTable);
		h.first();
		String exUid = h.getString(srcUidField);
		DataTable qryTgt = context.getDBManager().execPrepareQuery(
				"SELECT OID FROM "+tgtHeadTable+" WHERE "+tgtUidField+" = ?", exUid);
		long tgtOID;
		if (qryTgt.first()){
			tgtOID = qryTgt.getLong("OID");
		}else{
			tgtOID = -1;
		}
		
		Document tgtDoc;
		if (tgtOID>0){
			LoadFormData load = new LoadFormData(tgtDataObjectKey, tgtOID);
			tgtDoc = load.load(new DefaultContext(context), null);
		}else{
			tgtDoc = DocumentUtil.newDocument(tgtDataObjectKey, context.getVE().getMetaFactory());
			tgtDoc.setNew();
		}
		
		return tgtDoc;
	}

}
