package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.file.provider.IAttachmentProvider;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.poi.ss.usermodel.Workbook;

import javax.transaction.NotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;

public class StorageUtil {
	/**
	 * 保存二进制数据到存储服务
	 *
	 * @param ctx – 中间层服务上下文
     * @param fileName – 文件名
     * @param formKey – 表单标识
     * @param SOID – 表单唯一标识
     * @param oldPath – 旧文件路径
     * @param seriesPath – 附件分类存储路径, 拼接在 ${DataObjectKey}/${formKey}/${OID} 路径之前
     * @param bytes – 文件字节数组
	 * @return 文件标识, 默认实现下是一个相对路径
	 * @throws Throwable {@link IAttachmentProvider#upload(DefaultContext, String, String, long, String, String, byte[], boolean)} 方法出错的向上处理
	 */
	public static String writeFile(DefaultContext ctx, String fileName, String formKey, long SOID, String oldPath,
			String seriesPath, byte[] bytes) throws Throwable {
		return AttachmentUtil.newProvider("", ctx.getVE()).upload(ctx, fileName, formKey, SOID, oldPath, seriesPath, bytes, true);
	}
	
	/**
	 * 保存文件到存储服务
	 *
	 * @param ctx – 中间层服务上下文
     * @param fileName – 文件名
     * @param formKey – 表单标识
     * @param SOID – 表单唯一标识
     * @param oldPath – 旧文件路径
     * @param seriesPath – 附件分类存储路径, 拼接在 ${DataObjectKey}/${formKey}/${OID} 路径之前
	 * @param file 文件对象
	 * @return 文件标识, 默认实现下是一个相对路径
	 * @throws Throwable {@link IAttachmentProvider#upload(DefaultContext, String, String, long, String, String, byte[], boolean)} 方法出错的向上处理
	 */
	public static String writeFile(DefaultContext ctx, String fileName, String formKey, long SOID, String oldPath,
			String seriesPath, File file) throws Throwable {
		try (FileInputStream fis = new FileInputStream(file)){			
		    byte[] data = IOUtils.toByteArray(fis);
			IAttachmentProvider attachmentProvider = AttachmentUtil.newProvider("", ctx.getVE());
			return attachmentProvider.upload(ctx, fileName, formKey, SOID, oldPath, seriesPath, data, true);
		}
	}

	/**
	 * 读取文件的二进制内容
	 *
	 * @param ctx 中间层服务上下文
	 * @param formkey 表单标识
	 * @param path 由 {@link IAttachmentProvider#upload(DefaultContext, String, String, long, String, String, byte[], boolean)} 方法
	 *             返回的文件标识, 默认实现下是一个相对路径
	 * @return byte[]
	 * @throws Throwable 1. {@link IAttachmentProvider#download(DefaultContext, String, String)} 方法出错 \n
	 *                   2. 返回值不支持
	 *
	 */
	public static byte[] readFile(DefaultContext ctx, String formkey, String path) throws Throwable {
		IAttachmentProvider attachmentProvider = AttachmentUtil.newProvider("", ctx.getVE());
		Class<?> returnTtype = MethodUtils.getAccessibleMethod(attachmentProvider.getClass(),
				"download",DefaultContext.class,String.class,String.class).getReturnType();
		if (returnTtype.equals(byte[].class)) {
			// 如果直接使用 attachmentProvider.download(ctx, formkey, path),会出现类型转化错误,byte[]无法转化成Object
			return (byte[]) MethodUtils.getAccessibleMethod(attachmentProvider.getClass(),
					"download",DefaultContext.class,String.class,String.class).invoke(attachmentProvider,ctx,formkey,path);
		}
		if(returnTtype.equals(Object.class)) {
			Object result = attachmentProvider.download(ctx, formkey, path);
			if (result instanceof byte[]) {
				return (byte[]) result;
			}
			if (result instanceof FileData) {
				return ((FileData) result).getData();
			}
		}
		throw new NotSupportedException("Yigo AttachmentProvider:"+attachmentProvider.getClass()+",download funciton return is not byte[] or "+FileData.class.getName());
	}

	/**
	 * 保存xls、xlsx的workbook对象到存储服务
	 * @param ctx – 中间层服务上下文
     * @param fileName – 文件名
     * @param formKey – 表单标识
     * @param SOID – 表单唯一标识
     * @param oldPath – 旧文件路径
     * @param seriesPath – 附件分类存储路径, 拼接在 ${DataObjectKey}/${formKey}/${OID} 路径之前
	 * @param workbook excel的内存对象
	 * @return 文件标识, 默认实现下是一个相对路径
	 * @throws Throwable {@link IAttachmentProvider#upload(DefaultContext, String, String, long, String, String, byte[], boolean)} 方法出错的向上处理
	 */
	public static String writeExcel(DefaultContext ctx, String fileName, String formKey, long SOID,
			String oldPath, String seriesPath, Workbook workbook) throws Throwable {
		try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
			workbook.write(bos);
			byte[] data = bos.toByteArray();
			IAttachmentProvider attachmentProvider = AttachmentUtil.newProvider("", ctx.getVE());
			return attachmentProvider.upload(ctx, fileName, formKey, SOID, oldPath, seriesPath, data, true);
		}
	}
}
