package com.bokesoft.distro.tech.yigosupport.extension.intf;

import java.util.ServiceLoader;

import com.bokesoft.distro.tech.yigosupport.extension.base.IExtServiceWrapper;
import com.bokesoft.yigo.mid.service.IExtService;

/**
 * 标识自动注册的 Yigo 扩展服务({@link IExtService}).
 * <br/>
 * 具体实现方式采用 Java {@link ServiceLoader} 机制, 因此需要在 META-INF/services 目录下创建的
 * 文本文件 "com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceWrapperService" 中
 * 加上实现类名称.
 */
public interface IExtServiceWrapperService {
	/**
	 * 一个 {@link IExtServiceWrapperService} 对应一组相近的服务, 因此可以统一给服务一个前缀.
	 * @return
	 */
	String getServicePrefix();
	
	/**
	 * 自动注册需要服务自己标识名称等属性, 因此需要实现 {@link IExtService} 的扩展接口 {@link IExtServiceWrapper}
	 * @return
	 */
	Class<? extends IExtServiceWrapper>[] getWrappers();
}
