package com.bokesoft.distro.tech.yigosupport.extension.impl;

import com.bokesoft.distro.tech.yigosupport.extension.intf.IServiceIdCalculator;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct.ServiceIdParts;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * 默认的 serviceId 调整计算逻辑
 */
public class DefaultServiceIdCalculator implements IServiceIdCalculator {

	@Override
	public void calculate(ServiceIdParts parts, String originalServiceId, Map<String, Object> args) {
		//补充 formKey、itemKey、dataObjectKey
		if (StringUtils.isBlank(parts.getObject())) {
			if (args.containsKey(ARGUMENT_NAME_FORM_KEY)) {
				parts.setObject((String)args.get(ARGUMENT_NAME_FORM_KEY));
			}else if (args.containsKey(ARGUMENT_NAME_METAFORM_KEY)) {
				parts.setObject((String)args.get(ARGUMENT_NAME_METAFORM_KEY));
			}else if (args.containsKey(ARGUMENT_NAME_ITEM_KEY)) {
				parts.setObject((String)args.get(ARGUMENT_NAME_ITEM_KEY));
			}else if (args.containsKey(ARGUMENT_NAME_DATAOBJECT_KEY)) {
				parts.setObject((String)args.get(ARGUMENT_NAME_DATAOBJECT_KEY));
			}
		}
	}

}
