package com.bokesoft.distro.tech.yigosupport.extension.exception;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yigo.common.exception.CoreException;

/**
 * {@link MiscUtil} 中遗失的与 Yigo Exception 相关的功能.
 */
public class Misc {
	private Misc(){}

	/**
	 * 将 Exception 转化为 Yigo 的 Exception 以便能够正确的传递到 UI 层展现
	 * @param ex exception实例
	 * @param logger logger实例
	 * @return
	 */
	public static CoreException convertToYigoException(Exception ex, Logger logger) {
		return convertToYigoException((Throwable)ex, null, logger);
	}

	/**
	 * 将 Throwable 转化为 Yigo 的 Exception 以便能够正确的传递到 UI 层展现
	 * @param ex throwable实例
	 * @param logger logger实例
	 * @return
	 */
	public static CoreException convertToYigoException(Throwable ex, Logger logger) {
		return convertToYigoException(ex, null,logger);
	}

	/**
	 * 将 Throwable 转化为 Yigo 的 Exception,且修改报错描述,以便能够正确的传递到 UI 层展现
	 * @param e trhowable实例
	 * @param manualMsg  指定的报错描述
	 * @return
	 */
	public static CoreException convertToYigoException(Throwable e,String manualMsg) {
		return convertToYigoException(e, manualMsg, null);
	}

	/**
	 * 将 Throwable 转化为 Yigo 的 Exception,且修改报错描述,以便能够正确的传递到 UI 层展现
	 * @param ex throwable实例
	 * @param manualMsg 指定的报错描述
	 * @param logger logger实例
	 * @return
	 */
	public static CoreException convertToYigoException(Throwable ex,String manualMsg, Logger logger) {
		int errCode = CustomUserException.BASE_ERROR;
		Throwable root;
		CoreException core = MiscUtil.findCause(ex, CoreException.class);
		if (null!=core) {
			errCode = core.getCode();
			root = core;
		}else {
			root = ExceptionUtils.getRootCause(ex);
			if (null==root) {
				root = ex;
			}
		}
		if(null != logger){
			logger.error(ex.getMessage(), ex);
		}
		// 如果 manualMsg为空 则获取 rootException中的message
		if(StringUtils.isBlank(manualMsg)){
			manualMsg = root.getMessage();
			// 如果 rootException中的message还是空,例如 NullPointException的message就是null,则返回Exception的类名
			if (StringUtils.isBlank(manualMsg) || "null".equals(manualMsg.trim())) {
				manualMsg = root.getClass().getName();
			}
		}
		if(root instanceof CoreException){
			root = ExceptionUtils.getRootCause(core);
		}
		CustomUserException finalException = new CustomUserException(errCode,manualMsg,true);
		finalException.initCause(root);
		return finalException;
	}

}
