/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataUtils {
    public static final List<Map<String, Object>> wrapDataTable(DataTable dt, boolean upperCaseFieldName) {
        DataTableMetaData md = dt.getMetaData();
        int colCount = md.getColumnCount();
        ArrayList<String> colNames = new ArrayList<String>();
        for (int i = 0; i < colCount; ++i) {
            colNames.add(md.getColumnInfo(i).getColumnKey());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        dt.beforeFirst();
        while (dt.next()) {
            HashMap<String, Object> line = new HashMap<String, Object>();
            for (String col : colNames) {
                Object val = dt.getObject(col);
                if (upperCaseFieldName) {
                    line.put(col.toUpperCase(), val);
                    continue;
                }
                line.put(col, val);
            }
            result.add(line);
        }
        return result;
    }

    public static final Map<String, Object> wrapDocument(Document document, List<String> ignoreTables) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String mainTable = document.getMetaDataObject().getMainTableKey();
        DataTable mainDt = document.get(mainTable);
        DataTableMetaData md = mainDt.getMetaData();
        int colCount = md.getColumnCount();
        ArrayList<String> colNames = new ArrayList<String>();
        for (int i = 0; i < colCount; ++i) {
            colNames.add(md.getColumnInfo(i).getColumnKey());
        }
        mainDt.first();
        for (String colName : colNames) {
            result.put(colName, mainDt.getObject(colName));
        }
        MetaTableCollection tableCollection = document.getMetaDataObject().getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().equals(mainTable) || null != ignoreTables && ignoreTables.contains(metaTable.getKey())) continue;
            DataTable dt = document.get(metaTable.getKey());
            result.put(metaTable.getKey(), DataUtils.wrapDataTable(dt, false));
        }
        return result;
    }

    public static DataTable createEmptyDataTable(DefaultContext ctx, String formKey, String tableKey) {
        try {
            MetaForm metaForm = ctx.getVE().getMetaFactory().getMetaForm(formKey);
            MetaTable metaTable = metaForm.getMetaTable(tableKey);
            return DataTableUtil.newEmptyDataTable((MetaTable)metaTable);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("formeky:" + formKey + ",tableKey:" + tableKey + " init datatable error!" + throwable.getMessage(), throwable);
        }
    }

    public static DataTable pageQuery(DefaultContext ctx, String sql, String orderSql, boolean isBeetween, int startPos, int endPos, List<Object> args) throws Throwable {
        IDBManager dbManager = ctx.getDBManager();
        PrepareSQL prepareSQL = dbManager.getLimitString(sql, orderSql, isBeetween, startPos, endPos);
        if (null == args) {
            args = prepareSQL.getPrepareValues();
        } else {
            args.addAll(prepareSQL.getPrepareValues());
        }
        return dbManager.execPrepareQuery(prepareSQL.getSQL(), args);
    }
}

