/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.system.request;

import com.bokesoft.yigo.common.trace.TraceRecorder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SystemRequestHolder {
    private static final Map<String, HttpServletRequest> aliveRequests = new ConcurrentHashMap<String, HttpServletRequest>();

    public static Map<String, HttpServletRequest> getAliveRequests() {
        return aliveRequests;
    }

    public static void addCurrentRequest(HttpServletRequest request) {
        String traceId = TraceRecorder.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            aliveRequests.remove(traceId);
        }
    }

    public static void removeCurrentRequest() {
        String traceId = TraceRecorder.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            aliveRequests.remove(traceId);
        }
    }

    public static int getAliveRequestCount() {
        return aliveRequests.size();
    }

    public static HttpServletRequest getRequest(String traceId) {
        return aliveRequests.get(traceId);
    }

    public static HttpServletRequest getCurrentRequest() {
        return SystemRequestHolder.getRequest(TraceRecorder.getTraceId());
    }
}

