/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.system;

import com.bokesoft.distro.tech.commons.basis.trace.TraceUtil;
import com.bokesoft.distro.tech.yigosupport.extension.system.dto.SystemInfoDTO;
import com.bokesoft.distro.tech.yigosupport.extension.system.request.SystemRequestHolder;
import com.bokesoft.yes.mid.ver.SystemInfo;
import com.bokesoft.yigo.mid.scheduler.QuartzManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;

public class SystemInfoService {
    public SystemInfoDTO getSystemInfo() {
        SystemInfoDTO info = new SystemInfoDTO();
        info.setYigoVersion(this.getYigoVersion());
        info.setErpVersion(this.getErpVersion());
        info.setCurrentRequests(this.getRequests());
        info.setExecutingQuartzJobs(this.getExecutingJobs());
        return info;
    }

    public List<String> getRequests() {
        HttpServletRequest curHttpReq = SystemRequestHolder.getCurrentRequest();
        Map<String, HttpServletRequest> currentRequests = SystemRequestHolder.getAliveRequests();
        ArrayList<String> requestStrList = new ArrayList<String>();
        for (Map.Entry<String, HttpServletRequest> httpServletRequestEntry : currentRequests.entrySet()) {
            HttpServletRequest request = httpServletRequestEntry.getValue();
            if (request == curHttpReq) continue;
            String requestURI = request.getRequestURI();
            String requestMethod = request.getMethod();
            String requestMsg = String.format("[\u6b63\u5728\u6267\u884c\u7684\u8bf7\u6c42: %s, \u8bf7\u6c42\u65b9\u6cd5: %s, TraceID: %s]", requestURI, requestMethod, TraceUtil.getTraceId());
            requestStrList.add(requestMsg);
        }
        return requestStrList;
    }

    public List<String> getExecutingJobs() {
        try {
            QuartzManager quartzManager = QuartzManager.getInstance();
            SchedulerFactory schedulerFactory = (SchedulerFactory)FieldUtils.readField((Object)quartzManager, (String)"schedulerFactory", (boolean)true);
            Scheduler scheduler = schedulerFactory.getScheduler();
            return this.getExecutingJobMsgsStr(scheduler);
        }
        catch (IllegalAccessException | SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getExecutingJobMsgsStr(Scheduler scheduler) throws SchedulerException {
        ArrayList<String> jobMsgs = new ArrayList<String>();
        for (JobExecutionContext currentlyExecutingJob : scheduler.getCurrentlyExecutingJobs()) {
            String jobMsg = SystemInfoService.getJobMsgsStr(currentlyExecutingJob);
            jobMsgs.add(jobMsg);
        }
        return jobMsgs;
    }

    private static String getJobMsgsStr(JobExecutionContext currentlyExecutingJob) {
        String jobName = currentlyExecutingJob.getJobDetail().getKey().getName();
        String jobGroup = currentlyExecutingJob.getJobDetail().getKey().getGroup();
        Date scheduledFireTime = currentlyExecutingJob.getScheduledFireTime();
        long jobRunTime = Duration.between(scheduledFireTime.toInstant(), new Date().toInstant()).toMillis();
        return String.format("[\u6b63\u5728\u6267\u884c\u7684 Job \u540d\u79f0: %s, \u5206\u7ec4: %s, \u8fd0\u884c\u65f6\u95f4: %d \u6beb\u79d2]", jobName, jobGroup, jobRunTime);
    }

    private String getErpVersion() {
        try {
            Class<?> clazz = Class.forName("com.bokesoft.yes.util.ProjectSystemInfoUtil");
            Method getVersionMethod = clazz.getMethod("getVersion", new Class[0]);
            Method getBuildIDMethod = clazz.getMethod("getBuildID", new Class[0]);
            Method getBuildRevisionMethod = clazz.getMethod("getBuildRevision", new Class[0]);
            String version = (String)getVersionMethod.invoke(null, new Object[0]);
            String buildId = (String)getBuildIDMethod.invoke(null, new Object[0]);
            String revision = (String)getBuildRevisionMethod.invoke(null, new Object[0]);
            return version + "@" + buildId + "@" + revision;
        }
        catch (ClassNotFoundException e) {
            return "UNKNOWN";
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String getYigoVersion() {
        return SystemInfo.getVersion() + "@" + SystemInfo.getBuildID();
    }
}

