/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yes;

import com.bokesoft.base.bokebase.rediscache.IDataDescriber;
import com.bokesoft.base.bokebase.rediscache.struct.DescrFormat;
import com.bokesoft.base.bokebase.rediscache.struct.ValueDescription;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public class MobileSessionCacheDataDescriptor
implements IDataDescriber<ISessionInfo> {
    public static final String CACHEKEY = "MobileCache";

    public ValueDescription describeData(String key, ISessionInfo sessionInfo) {
        ValueDescription valueDescription = new ValueDescription();
        String desc = this.getSessionDescription(sessionInfo);
        valueDescription.setDescription(desc);
        valueDescription.setFormat(DescrFormat.PLAIN);
        return valueDescription;
    }

    public String describeKey(String s) {
        return "Yigo\u624b\u6301\u4f1a\u8bdd\u7f13\u5b58";
    }

    public String describeHashKey(String k, String hashKey, ISessionInfo sessionInfo) {
        String code = sessionInfo.getUserCode();
        String name = sessionInfo.getUserName();
        return "\u64cd\u4f5c\u5458:" + code + "/" + name + "\u7684\u7f13\u5b58HashKey:" + hashKey;
    }

    private String getSessionDescription(ISessionInfo sessionInfo) {
        String ip;
        String clientID = sessionInfo.getClientID();
        String desc = "\u4f1a\u8bdd/clientID:'" + clientID + "'\n";
        int mode = sessionInfo.getMode();
        desc = desc + ", \u767b\u5f55\u6a21\u5f0f:'" + LoginMode.toString((int)mode) + "'\n";
        if (mode == 2) {
            ip = sessionInfo.getAppID();
            desc = desc + ", \u8bbe\u5907ID/appID:'" + ip + "'\n";
        }
        ip = sessionInfo.getIP();
        desc = desc + ", \u8bf7\u6c42ip\u5730\u5740:'" + ip + "'\n";
        if (mode != 0) {
            long operatorID = sessionInfo.getOperatorID();
            desc = desc + ", \u64cd\u4f5c\u5458ID/operatorID:" + operatorID + "\n";
            String code = sessionInfo.getUserCode();
            desc = desc + ", \u64cd\u4f5c\u5458code:'" + code + "'\n";
            String name = sessionInfo.getUserName();
            desc = desc + ", \u64cd\u4f5c\u5458\u540d/name:'" + name + "'\n";
            Date loginDate = sessionInfo.getLoginTime();
            LocalDateTime loginTime = LocalDateTime.ofInstant(loginDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", \u767b\u5f55\u65f6\u95f4/loginTime:" + loginTime + "\n";
            Date lastDate = sessionInfo.getLastActiveTime();
            LocalDateTime lastActiveTime = LocalDateTime.ofInstant(lastDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", \u6700\u540e\u6d3b\u8dc3\u65f6\u95f4/lastActiveTime:" + lastActiveTime + "\n";
            long clusterID = sessionInfo.getClusterID();
            desc = desc + ", \u96c6\u56e2ID:clusterID:" + clusterID + "\n";
            boolean isAuthenticated = sessionInfo.isAuthenticated();
            desc = desc + ", \u662f\u5426\u5df2\u9a8c\u8bc1/isAuthenticated:" + isAuthenticated + "\n";
            int loginFailedCount = sessionInfo.getLoginFailedCount();
            desc = desc + ", \u767b\u5f55\u5931\u8d25\u6b21\u6570:loginFailedCount:" + loginFailedCount + "\n";
            Map sessionParas = sessionInfo.getSessionParas();
            if (sessionParas != null) {
                desc = desc + ", \u5176\u4ed6\u4f1a\u8bdd\u53c2\u6570/sessionParas:" + sessionParas.toString() + "\n";
            }
        } else {
            String validateCode = sessionInfo.getValidateCode();
            desc = desc + ", \u5bf9\u5e94\u56fe\u5f62\u9a8c\u8bc1\u7801/validateCode:'" + validateCode + "'\n";
            Date createDate = sessionInfo.getCreateTime();
            LocalDateTime createTime = LocalDateTime.ofInstant(createDate.toInstant(), ZoneId.systemDefault());
            desc = desc + ", \u521b\u5efa\u65f6\u95f4/createTime:" + createTime + "\n";
        }
        return desc;
    }
}

