/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.impl;

import com.bokesoft.yigo.mid.base.DefaultContext;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class WrapperUtils {
    public static String findStaticMethod(DefaultContext ctx, Class<?> clazz, Object[] args, String targetMethodName) throws ReflectiveOperationException {
        String mDisp;
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.add(ctx);
        tmp.addAll(Arrays.asList(args));
        Object[] argsWithCtx = tmp.toArray();
        argsWithCtx = ArrayUtils.nullToEmpty((Object[])argsWithCtx);
        Class[] parameterTypesWithCtx = ClassUtils.toClass((Object[])argsWithCtx);
        List<Method> matchedMethods = WrapperUtils.findStaticMethods(clazz, parameterTypesWithCtx, targetMethodName);
        if (matchedMethods.size() < 1) {
            matchedMethods = WrapperUtils.findStaticMethods(clazz, parameterTypes, targetMethodName);
        }
        String string = mDisp = null == targetMethodName ? "*" : targetMethodName;
        if (matchedMethods.size() < 1) {
            throw new NoSuchMethodException("\u627e\u4e0d\u5230\u65b9\u6cd5: Class='" + clazz + "', method='" + mDisp + "', parameterTypes='" + WrapperUtils.toStr(parameterTypes) + "'");
        }
        if (matchedMethods.size() > 1) {
            throw new NoSuchMethodException("\u65b9\u6cd5\u65e0\u6cd5\u786e\u5b9a: Class='" + clazz + "', method='" + mDisp + "', parameterTypes='" + WrapperUtils.toStr(parameterTypes) + "' \u5177\u6709\u591a\u4e2a\u65b9\u6cd5 - " + WrapperUtils.toStr(matchedMethods));
        }
        return matchedMethods.get(0).getName();
    }

    private static String toStr(Class<?>[] parameterTypes) {
        return "[" + StringUtils.join((Object[])parameterTypes, (String)", ") + "]";
    }

    private static String toStr(List<Method> methods) {
        return "[" + StringUtils.join(methods, (String)", ") + "]";
    }

    protected static List<Method> findStaticMethods(Class<?> clazz, Class<?>[] parameterTypes, String targetMethodName) {
        ArrayList<Method> matchedMethods = new ArrayList<Method>();
        Method[] methods = clazz.getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method m : methods) {
            String methodName;
            int modifiers;
            if (null != targetMethodName && !targetMethodName.equals(m.getName()) || !Modifier.isStatic(modifiers = m.getModifiers()) || !Modifier.isPublic(modifiers) || methodNames.contains(methodName = m.getName())) continue;
            methodNames.add(methodName);
            Method tmp = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])parameterTypes);
            if (null == tmp) continue;
            matchedMethods.add(tmp);
        }
        return matchedMethods;
    }

    public static Object tryRunStaticMethod(DefaultContext ctx, Class<?> clazz, String method, Object[] args) throws ReflectiveOperationException {
        try {
            Object[] argsWithCtx = new Object[args.length + 1];
            argsWithCtx[0] = ctx;
            for (int i = 0; i < args.length; ++i) {
                argsWithCtx[i + 1] = args[i];
            }
            return MethodUtils.invokeStaticMethod(clazz, (String)method, (Object[])argsWithCtx);
        }
        catch (NoSuchMethodException ne) {
            return MethodUtils.invokeStaticMethod(clazz, (String)method, (Object[])args);
        }
    }
}

