/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.exttools.sdk;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.extension.exception.GeneralUserException;
import com.bokesoft.distro.tech.yigosupport.extension.utils.codecs.AESUtils;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptImpl {
    private static final char HEADER_JOIN_CHAR = ':';
    public static final String ENCRYPT_PREFIX_AES = "=*";
    private static final Logger log = LoggerFactory.getLogger(EncryptImpl.class);
    private final Configer configer;
    private List<String> AES_KEYS = null;
    private List<String> HEADERS = null;

    public EncryptImpl(Configer configer) {
        this.configer = configer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> lazyloadAESKey() throws UnsupportedEncodingException {
        if (null != this.AES_KEYS) return this.AES_KEYS;
        Class<EncryptImpl> clazz = EncryptImpl.class;
        synchronized (EncryptImpl.class) {
            if (null != this.AES_KEYS) return this.AES_KEYS;
            this.AES_KEYS = new ArrayList<String>();
            List<String> keys = null;
            if (null != this.configer) {
                keys = this.configer.getEncryptKeys();
            }
            if (null != keys) {
                for (String seed : keys) {
                    if (!StringUtils.isNotBlank((CharSequence)seed)) continue;
                    this.AES_KEYS.add(AESUtils.getSecretKey(seed.trim()));
                }
            }
            if (!this.AES_KEYS.isEmpty()) return this.AES_KEYS;
            throw new UnsupportedOperationException("Seeds not configurated, use 'EncryptImpl.initConfiger(configer)'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> lazyloadHeader() {
        if (null != this.HEADERS) return this.HEADERS;
        Class<EncryptImpl> clazz = EncryptImpl.class;
        synchronized (EncryptImpl.class) {
            if (null != this.HEADERS) return this.HEADERS;
            this.HEADERS = new ArrayList<String>();
            List<String> headers = null;
            if (null != this.configer) {
                headers = this.configer.getHeaders();
            }
            if (null != headers) {
                for (String hd : headers) {
                    if (!StringUtils.isNotBlank((CharSequence)hd)) continue;
                    if (hd.indexOf(58) >= 0) {
                        throw new UnsupportedOperationException("Headers configuration error, with invalid char ':': " + hd);
                    }
                    this.HEADERS.add(hd.trim() + ':');
                }
            }
            this.HEADERS.add("");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.HEADERS;
        }
    }

    public String encrypt(String value, String prefix) {
        block6: {
            if (null == value) {
                return null;
            }
            try {
                value = this.decrypt(value);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("\u5728\u52a0\u5bc6\u524d\u5c1d\u8bd5\u89e3\u5bc6 '{}' \u9519\u8bef: {}", (Object)value, (Object)e.getMessage());
            }
        }
        String header = this.lazyloadHeader().get(0);
        if (ENCRYPT_PREFIX_AES.equals(prefix)) {
            try {
                return header + this.encryptAES(value);
            }
            catch (UnsupportedEncodingException e) {
                throw MiscUtil.toRuntimeException((Throwable)e);
            }
        }
        throw new GeneralUserException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u65b9\u5f0f: " + prefix);
    }

    public String decrypt(String value) {
        if (null == value) {
            return null;
        }
        List<String> headers = this.lazyloadHeader();
        for (String hd : headers) {
            if (!value.startsWith(hd)) continue;
            value = value.substring(hd.length());
            break;
        }
        if (value.startsWith(ENCRYPT_PREFIX_AES)) {
            try {
                return this.decryptAES(value);
            }
            catch (UnsupportedEncodingException e) {
                throw MiscUtil.toRuntimeException((Throwable)e);
            }
        }
        throw new GeneralUserException("\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef");
    }

    public void encryptDocument(Document doc, String tableName, String fieldName, String prefix) {
        EncryptImpl.processDocument(doc, tableName, fieldName, "\u5b57\u6bb5\u52a0\u5bc6", true, value -> this.encrypt((String)value, prefix));
    }

    public void decryptDocument(Document doc, String tableName, String fieldName) {
        EncryptImpl.processDocument(doc, tableName, fieldName, "\u5b57\u6bb5\u89e3\u5bc6", false, value -> {
            try {
                return this.decrypt((String)value);
            }
            catch (Exception e) {
                return value;
            }
        });
    }

    private String encryptAES(String value) throws UnsupportedEncodingException {
        List<String> keys = this.lazyloadAESKey();
        String key = keys.get(0);
        try {
            String enVal = AESUtils.encrypt(value, key);
            return ENCRYPT_PREFIX_AES + enVal;
        }
        catch (Exception e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    private String decryptAES(String value) throws UnsupportedEncodingException {
        String rawValue = value.substring(ENCRYPT_PREFIX_AES.length());
        List<String> keys = this.lazyloadAESKey();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String key = keys.get(i);
            try {
                String deVal = AESUtils.decrypt(rawValue, key);
                return deVal;
            }
            catch (Exception e) {
                log.warn("\u4f7f\u7528\u7b2c " + i + "\u4e2a\u5bc6\u94a5\u89e3\u5bc6\u9519\u8bef: " + e.getMessage());
                continue;
            }
        }
        return value;
    }

    private static void processDocument(Document doc, String tableName, String fieldName, String descr, boolean changeState, Function<String, String> runner) {
        DataTable tbl = doc.get(tableName);
        if (null == tbl) {
            throw new GeneralUserException("\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230\u6570\u636e\u8868 [" + tableName + "]");
        }
        int size = tbl.size();
        if (size <= 0) {
            return;
        }
        int fieldIdx = tbl.getMetaData().findColumnIndexByKey(fieldName, true);
        for (int i = 0; i < size; ++i) {
            String val = tbl.getString(i, fieldName);
            if (null == val) continue;
            log.info("\u6b63\u5728\u5904\u7406 '{}': {}.{} \u7684 \u7b2c [{}] \u884c, {} ...", new Object[]{descr, tableName, fieldName, i, changeState ? "<\u8bb0\u5f55\u4fee\u6539\u72b6\u6001>" : "<\u4fdd\u7559\u4fee\u6539\u72b6\u6001>"});
            val = runner.apply(val);
            tbl.setObject(i, fieldIdx, (Object)val, changeState);
        }
    }

    public static interface Configer {
        public List<String> getEncryptKeys();

        public List<String> getHeaders();
    }
}

