/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.coordinate;

import com.bokesoft.distro.tech.commons.basis.coordinate.impl.SimpleLeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ILeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.LeaderStatusConfig;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl.YigoLeaderStatusDetectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderStatusDetectors {
    private static ILeaderStatusDetector detector;
    private static final Logger log;

    private LeaderStatusDetectors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ILeaderStatusDetector detector() {
        if (detector != null) return detector;
        Class<LeaderStatusDetectors> clazz = LeaderStatusDetectors.class;
        synchronized (LeaderStatusDetectors.class) {
            if (detector != null) return detector;
            try {
                YigoLeaderStatusDetectorFactory factory = new YigoLeaderStatusDetectorFactory();
                detector = factory.create();
            }
            catch (Exception e) {
                log.error("LeaderStatusDetector \u521d\u59cb\u5316\u5931\u8d25,\u4f7f\u7528\u56de\u9000\u5b9e\u73b0!", (Throwable)e);
                detector = new SimpleLeaderStatusDetector();
            }
            return detector;
        }
    }

    public static boolean isLeader(String bizTag) {
        return LeaderStatusDetectors.detector().isLeader(bizTag);
    }

    public static void register(String key, LeaderStatusConfig config) {
        LeaderStatusDetectors.detector().register(key, config);
    }

    static {
        log = LoggerFactory.getLogger(LeaderStatusDetectors.class);
    }
}

