/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension;

import com.bokesoft.distro.tech.yigosupport.extension.impl.BaseStaticWrapperMidFuncRunner;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IFunctionProviderService;
import com.bokesoft.yigo.parser.IFunImplCluster;
import com.bokesoft.yigo.parser.IFunctionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderMidFunctionProvider
implements IFunctionProvider {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderMidFunctionProvider.class);

    public IFunImplCluster[] getClusters() {
        ArrayList<IFunImplCluster> result = new ArrayList<IFunImplCluster>();
        ServiceLoader<IFunctionProviderService> fpss = ServiceLoader.load(IFunctionProviderService.class);
        for (IFunctionProviderService fps : fpss) {
            IFunImplCluster[] clusters;
            String info = "Loading IFunctionProviderService '" + fps.getClass().getName() + "'";
            ArrayList<String> allFuncInfos = new ArrayList<String>();
            try {
                log.info(info + " (" + fps.getClass().getProtectionDomain().getCodeSource().getLocation().getPath() + ") ...");
            }
            catch (Exception ex) {
                log.info(info + " ...");
            }
            IFunctionProvider fp = fps.getFunctionProvider();
            if (null != fp && null != (clusters = fp.getClusters())) {
                for (int i = 0; i < clusters.length; ++i) {
                    IFunImplCluster c = clusters[i];
                    this.logFunctions(c, allFuncInfos);
                    result.add(c);
                }
            }
            if (allFuncInfos.size() > 0) {
                String allFuncs = StringUtils.join(allFuncInfos, (String)"\n\t");
                log.info(info + " completed .\n\t" + allFuncs);
                continue;
            }
            log.info(info + " completed .");
        }
        return result.toArray(new IFunImplCluster[0]);
    }

    private void logFunctions(IFunImplCluster c, List<String> infos) {
        Object[][] table;
        for (Object[] funcPair : table = c.getImplTable()) {
            Object funcImpl;
            String funcInfo = funcPair.length > 0 ? funcPair[0] + "" : "<INVALID>";
            Object object = funcImpl = funcPair.length > 1 ? funcPair[1] : null;
            if (null == funcImpl) {
                funcInfo = funcInfo + ": " + null;
            } else if (funcImpl instanceof BaseStaticWrapperMidFuncRunner) {
                BaseStaticWrapperMidFuncRunner r = (BaseStaticWrapperMidFuncRunner)((Object)funcImpl);
                funcInfo = funcInfo + ": " + r.getWrapperInfo();
            } else {
                funcInfo = funcInfo + ": " + funcImpl.getClass().getName();
            }
            log.debug(">>> " + funcInfo);
            infos.add(funcInfo);
        }
    }
}

