package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.filter;

import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceFilterProvider;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.ContextUtil;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;

import java.util.Map;

/**
 * Yigo服务信息预处理过滤器的供应类
 */
public class YigoExtServiceInfoPrepareFilterProvider implements IExtServiceFilterProvider {
    @Override
    public IServiceFilter getFilter() {
        return new YigoServiceInfoPrepareFilter();
    }

    public static class YigoServiceInfoPrepareFilter implements IServiceFilter {
        @Override
        public void preProcess(IServiceContext c, Map<String, Object> args) throws Throwable {
            ContextUtil.set(args);
        }

        @Override
        public void postProcess(IServiceContext c, Map<String, Object> args) throws Throwable {
            // Do nothing
        }

        @Override
        public void errorProcess(IServiceContext c, Map<String, Object> args, Throwable e) throws Throwable {
            // Do nothing
        }

        @Override
        public void finalProcess(IServiceContext c, Map<String, Object> args) throws Throwable {
            ContextUtil.remove();
        }

        @Override
        public void checkSecurity(IServiceContext c, Map<String, Object> args) throws Throwable {
            // Do nothing
        }
    }
}
