package com.bokesoft.distro.tech.yigosupport.extension.utils.codecs;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

/**
 * AES加密解密工具包
 */
public class AESUtils {

	private static final String ALGORITHM = "AES";
	
	/** 在Java7使用256位密钥的AES算法需要获得无政策限制权限文件（Unlimited Strength Jurisdiction Policy Files） */
	private static final int KEY_SIZE = 128;

	/**
	 * 生成随机密钥
	 * 
	 * @return
	 * @throws Exception
	 */
	public static String getRandomSecretKey() throws Exception {
		return getRandomSecretKey(null);
	}

	/**
	 * 通过种子生成随机密钥
	 * 
	 * @param seed 密钥种子
	 * @return
	 * @throws GeneralSecurityException 
	 */
	public static String getRandomSecretKey(String seed) throws GeneralSecurityException {
		KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
		SecureRandom secureRandom;
		if (seed != null && !"".equals(seed)) {
			secureRandom = new SecureRandom(seed.getBytes());
		} else {
			secureRandom = new SecureRandom();
		}
		keyGenerator.init(KEY_SIZE, secureRandom);
		SecretKey secretKey = keyGenerator.generateKey();
		return Base64.encodeBase64String(secretKey.getEncoded());
	}
	
	/**
	 * 通过种子产生密钥
	 * @param seed
	 * @return
	 * @throws UnsupportedEncodingException 
	 */
	public static String getSecretKey(String seed) throws UnsupportedEncodingException {
		seed = seed.length()+":"+seed;
		String encrypted = GO9.encryptPWD(seed);
		encrypted = StringUtils.reverse(encrypted);
		byte[] bytes = encrypted.getBytes("ISO8859-1");
		bytes = Arrays.copyOf(bytes, 16);
		return Base64.encodeBase64String(bytes);
	}

	/**
	 * 加密
	 * 
	 * @param data
	 * @param key
	 * @return Base64 编码后的加密结果
	 * @throws GeneralSecurityException 
	 * @throws UnsupportedEncodingException 
	 */
	public static String encrypt(String data, String key) throws GeneralSecurityException, UnsupportedEncodingException {
		Key k = toKey(Base64.decodeBase64(key));
		byte[] raw = k.getEncoded();
		SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
		byte[] bytes = cipher.doFinal(data.getBytes("UTF-8"));
		return Base64.encodeBase64String(bytes);
	}

	/**
	 * 解密
	 * 
	 * @param data Base64 编码后的加密结果数据
	 * @param key
	 * @return
	 * @throws GeneralSecurityException
	 * @throws UnsupportedEncodingException 
	 */
	public static String decrypt(String data, String key) throws GeneralSecurityException, UnsupportedEncodingException {
		Key k = toKey(Base64.decodeBase64(key));
		byte[] raw = k.getEncoded();
		SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
		byte[] bytes = cipher.doFinal(Base64.decodeBase64(data));
		return new String(bytes, "UTF-8");
	}


	/**
	 * 转换密钥
	 * 
	 * @param key
	 * @return
	 */
	private static Key toKey(byte[] key) {
		SecretKey secretKey = new SecretKeySpec(key, ALGORITHM);
		return secretKey;
	}

}
