package com.bokesoft.distro.tech.yigosupport.extension.filter;


import com.bokesoft.distro.tech.yigosupport.extension.system.request.SystemRequestHolder;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 请求记录filter
 */
public class RequestTrackingFilter implements Filter {

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            SystemRequestHolder.addCurrentRequest((HttpServletRequest) servletRequest);
            filterChain.doFilter(servletRequest, servletResponse);
        } finally {
            SystemRequestHolder.removeCurrentRequest();
        }
    }
}
