package com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf;

import redis.clients.jedis.JedisPubSub;

public interface RedisCommands extends AutoCloseable {

    long ttl(String key);

    String get(String key);

    void setNxEx(final String key, final String value, long expire);

    long expire(final String key, final long seconds);

    boolean publish(String channel, String message);

    void psubscribe(JedisPubSub jedisPubSub, String channel);

    boolean remove(String key);

}

