package com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl;

import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisCommands;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.params.SetParams;

class SimpleRedisCommands implements RedisCommands {

    final Jedis jedis;

    public SimpleRedisCommands(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public void close() {
        jedis.close();
    }

    @Override
    public void setNxEx(String key, String value, long seconds) {
        jedis.set(key, value, SetParams.setParams().nx().ex(seconds));
    }

    @Override
    public long expire(String key, long seconds) {
        return jedis.expire(key, seconds);
    }

    @Override
    public boolean publish(String channel, String message) {
        return jedis.publish(channel, message) != 0;
    }

    @Override
    public long ttl(String key) {
        return jedis.ttl(key);
    }

    public String get(String key) {
        return jedis.get(key);
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String pattern) {
        jedis.psubscribe(jedisPubSub, pattern);
    }

    @Override
    public boolean remove(String key) {
        return jedis.del(key)!=0;
    }
}
