package com.bokesoft.distro.tech.yigosupport.extension;

import com.bokesoft.distro.tech.yigosupport.extension.impl.BaseStaticWrapperMidFuncImplCluster;
import com.bokesoft.yigo.parser.IFunImplCluster;
import com.bokesoft.yigo.parser.IFunctionProvider;

/**
 * 将指定的类中的静态方法包装成 Yigo 公式的通用的 {@link IFunctionProvider} 实现基类, 其具体实现规则
 * 参考 {@link BaseStaticWrapperMidFuncRegistryService}, 二者均是基于 {@link BaseStaticWrapperMidFuncImplCluster}
 * 的实现.
 * <hr/>
 * 在 Yigo 2.0 中使用时, 本类(的子类实现)需要手工在 solution 的 `Enhance.xml` 中注册，例如:
 *   <pre>
 *   &lt;ExtMidFunction&gt;
 *       &lt;MidFunction Provider="com.bokesoft.r2.cms2.adapter.yigo2.formula.CMS2FuncRegistry" Description="CMS2.0 中间层扩展公式"/&gt;
 *   &lt;/ExtMidFunction&gt;
 *   </pre>
 * @deprecated 建议替换为使用 {@link BaseStaticWrapperMidFuncRegistryService} 的实现, 以减少在
 *              `Enhance.xml` 中注册的手工操作.
 */
public abstract class BaseStaticWrapperMidFuncRegistry implements IFunctionProvider{
	/**
	 * 获取Yigo公式自定义前缀
	 * @return 获取Yigo公式自定义前缀
	 */
	protected abstract String getFormulaPrefix();

	/**
	 * 获取对应扩展开发处理类的类名集合
	 * @return 对应扩展开发处理类的类名集合
	 */
	protected abstract Class<?>[] getWrappers();

	/**
	 *
	 * @return
	 */
	@Override
	public IFunImplCluster[] getClusters() {
		return new IFunImplCluster[] {
			new BaseStaticWrapperMidFuncImplCluster(this.getFormulaPrefix(), this.getWrappers())
		};
	}
}
