/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io.internal;

import com.bokesoft.base.bokebase.instance.ProcessInstanceUtil;
import com.bokesoft.distro.tech.commons.basis.io.internal.LocalFileTempWriter;
import com.bokesoft.distro.tech.commons.basis.io.internal.WriterMonitor;
import com.bokesoft.distro.tech.commons.basis.io.internal.WriterParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TempWriterManager {
    private static final int DEFAULT_BLOCK_TIME_MS = 5000;
    static final Map<String, WriterParam> PARAMS_CACHE = new ConcurrentHashMap<String, WriterParam>();
    static final Map<String, LocalFileTempWriter<?>> WRITERS_CACHE = new ConcurrentHashMap();
    static long MONITOR_ROLLING_TIME = 10L;
    private static Thread monitor = null;
    public static final String VERSION = "v2";

    public static void bind(Class<?> clazz, String tmpDir, String readyDir, String errDir) {
        PARAMS_CACHE.put(clazz.getName(), new WriterParam(tmpDir, readyDir, errDir, 5000L));
    }

    public static void modifyBlockTime(Class<?> clazz, long blockTime) {
        PARAMS_CACHE.get(clazz.getName()).setBlockTime(blockTime);
    }

    public static LocalFileTempWriter<?> getWriter(Class<?> clazz) {
        String fileName = TempWriterManager.buildTmpFileName(clazz);
        return WRITERS_CACHE.computeIfAbsent(fileName, key -> new LocalFileTempWriter(fileName, clazz, PARAMS_CACHE.get(clazz.getName())));
    }

    public static List<String> getActiveTmpFiles() {
        return new ArrayList<String>(WRITERS_CACHE.keySet());
    }

    private static String buildTmpFileName(Class<?> clazz) {
        long blockTime = PARAMS_CACHE.get(clazz.getName()).getBlockTime();
        long timeCode = System.currentTimeMillis() / blockTime * blockTime;
        String name = clazz.getSimpleName() + "." + timeCode + "." + ProcessInstanceUtil.getInstanceId() + "." + VERSION;
        name = TempWriterManager.changeIllegalCharacter(name);
        return name;
    }

    protected static String changeIllegalCharacter(String name) {
        return name.replaceAll("(:|;|\\\\|/|\\?|\\*)", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMonitor() {
        if (null == monitor) {
            Thread thread = monitor = new Thread(new WriterMonitor());
            synchronized (thread) {
                monitor.start();
            }
        }
    }
}

