/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.dependency;

import com.bokesoft.distro.tech.commons.basis.dependency.IDependencySortable;
import com.bokesoft.distro.tech.commons.basis.exception.DependencyCyclicException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DependencySortCore {
    public static <T> List<T> sort(List<T> sortableList) {
        HashMap<Integer, String> nodeNoPool = new HashMap<Integer, String>(DependencySortCore.suitableSize(sortableList.size()));
        int[][] positions = DependencySortCore.initDAG(sortableList, nodeNoPool);
        int[] sortedPosition = DependencySortCore.findOrder(nodeNoPool.size(), positions, nodeNoPool);
        LinkedList<T> sortedRes = new LinkedList<T>();
        int[] nArray = sortedPosition;
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            Integer pos = nArray[i];
            String className = (String)nodeNoPool.get(pos);
            for (T o : sortableList) {
                if (!DependencySortCore.getClassName(o).equals(className)) continue;
                sortedRes.add(o);
                continue block0;
            }
        }
        return sortedRes;
    }

    private static String getClassName(Object node) {
        Class<?> cls = node.getClass();
        String clsName = cls.getName();
        if (clsName.contains("$$")) {
            return cls.getSuperclass().getName();
        }
        return clsName;
    }

    private static <T> Set<String> getAllNodeInDAG(List<T> nodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(DependencySortCore.suitableSize(nodes.size()));
        for (T node : nodes) {
            result.add(DependencySortCore.getClassName(node));
        }
        for (T node : nodes) {
            if (!(node instanceof IDependencySortable)) continue;
            IDependencySortable dependCalNode = (IDependencySortable)node;
            if (null != dependCalNode.getDependentClasses()) {
                Collections.addAll(result, dependCalNode.getDependentClasses());
            }
            if (null == dependCalNode.getDependencyClasses()) continue;
            Collections.addAll(result, dependCalNode.getDependencyClasses());
        }
        return result;
    }

    private static void markPos(Set<String> nodeSet, Map<Integer, String> nodeNoPool, Map<String, Integer> nodeNamePool) {
        int pos = 0;
        for (String nodeName : nodeSet) {
            nodeNoPool.put(pos, nodeName);
            nodeNamePool.put(nodeName, pos);
            ++pos;
        }
    }

    protected static <T> int[][] initDAG(List<T> nodes, Map<Integer, String> nodeNoPool) {
        Set<String> nodeSet = DependencySortCore.getAllNodeInDAG(nodes);
        HashMap<String, Integer> nodeNamePool = new HashMap<String, Integer>(DependencySortCore.suitableSize(nodes.size()));
        DependencySortCore.markPos(nodeSet, nodeNoPool, nodeNamePool);
        LinkedList<int[]> dependencySet = new LinkedList<int[]>();
        for (T node : nodes) {
            if (!(node instanceof IDependencySortable)) continue;
            int nodePos = (Integer)nodeNamePool.get(DependencySortCore.getClassName(node));
            IDependencySortable dependCalNode = (IDependencySortable)node;
            if (null != dependCalNode.getDependentClasses()) {
                for (String bdClass : dependCalNode.getDependentClasses()) {
                    dependencySet.add(new int[]{(Integer)nodeNamePool.get(bdClass), nodePos});
                }
            }
            if (null == dependCalNode.getDependencyClasses()) continue;
            for (String dClass : dependCalNode.getDependencyClasses()) {
                dependencySet.add(new int[]{nodePos, (Integer)nodeNamePool.get(dClass)});
            }
        }
        int[][] wholeDependencies = new int[dependencySet.size()][];
        int dpos = 0;
        Iterator iterator = dependencySet.iterator();
        while (iterator.hasNext()) {
            int[] ints;
            wholeDependencies[dpos] = ints = (int[])iterator.next();
            ++dpos;
        }
        return wholeDependencies;
    }

    private static int suitableSize(int size) {
        if (size < 8) {
            return 16;
        }
        return size * 2;
    }

    private static int[] findOrder(int numCourses, int[][] prerequisites, Map<Integer, String> nodeNoPool) {
        if (numCourses == 0) {
            return new int[0];
        }
        HashSet[] graph = new HashSet[numCourses];
        for (int i = 0; i < numCourses; ++i) {
            graph[i] = new HashSet();
        }
        for (int[] p : prerequisites) {
            graph[p[1]].add(p[0]);
        }
        int[] mark = new int[numCourses];
        Stack<Integer> stack = new Stack<Integer>();
        LinkedList<Integer> dagLink = new LinkedList<Integer>();
        StringBuilder cycleMsg = new StringBuilder("Cyclic dependency found:[");
        for (int i = 0; i < numCourses; ++i) {
            if (DependencySortCore.isNotCycle(graph, mark, i, stack, dagLink)) continue;
            for (int k = 0; k < dagLink.size(); ++k) {
                String objClassName = nodeNoPool.get(dagLink.get(k));
                if (k > 0) {
                    cycleMsg.append(" <- ");
                }
                cycleMsg.append(objClassName);
            }
            cycleMsg.append("]");
            ExceptionUtils.wrapAndThrow((Throwable)new DependencyCyclicException(cycleMsg.toString()));
        }
        int[] res = new int[numCourses];
        for (int i = 0; i < numCourses; ++i) {
            res[i] = stack.pop();
        }
        return res;
    }

    private static boolean isNotCycle(Set<Integer>[] graph, int[] mark, int i, Stack<Integer> stack, List<Integer> dagLink) {
        dagLink.add(i);
        if (mark[i] == -1) {
            return true;
        }
        if (mark[i] == 1) {
            return false;
        }
        mark[i] = 1;
        for (int neighbor : graph[i]) {
            if (DependencySortCore.isNotCycle(graph, mark, neighbor, stack, dagLink)) continue;
            return false;
        }
        mark[i] = -1;
        stack.push(i);
        return true;
    }
}

