/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MiscUtil {
    private MiscUtil() {
    }

    public static void throwRuntime(Throwable throwable) throws RuntimeException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static RuntimeException toRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static <T> T findCause(Throwable topEx, Class<T> stopLevel) {
        Throwable cause = topEx;
        while (null != cause) {
            if (stopLevel.isInstance(cause)) {
                return (T)cause;
            }
            if (cause instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)cause;
                cause = ite.getTargetException();
                continue;
            }
            cause = cause.getCause();
        }
        return null;
    }

    public static void $assert(boolean condition, String message) throws RuntimeException {
        if (condition) {
            throw new RuntimeException(message);
        }
    }

    public static String toStr(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static Integer toInt(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.intValue();
        }
        return Integer.valueOf(o.toString());
    }

    public static Map<String, Object> $attrs(Object ... keyAndValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < keyAndValue.length; ++i) {
            if (i % 2 != 1) continue;
            result.put((String)keyAndValue[i - 1], keyAndValue[i]);
        }
        return result;
    }

    public static Map<String, String> $props(String ... keyAndValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keyAndValue.length; ++i) {
            if (i % 2 != 1) continue;
            result.put(keyAndValue[i - 1], keyAndValue[i]);
        }
        return result;
    }

    public static List<Object> $list(Object ... value) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (int i = 0; i < value.length; ++i) {
            lst.add(value[i]);
        }
        return lst;
    }

    public static String $summary(Throwable e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        if (null == root || e == root) {
            return ExceptionUtils.getMessage((Throwable)e);
        }
        return ExceptionUtils.getMessage((Throwable)e) + "; " + ExceptionUtils.getMessage((Throwable)root);
    }

    public static String $detail(Throwable e) {
        Object[] stacks = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
        return MiscUtil.$summary(e) + "\n\t" + StringUtils.join((Object[])stacks, (String)"\n\t");
    }
}

