/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.jdbc;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCConverter {
    public static String JDBC_CHAR = "CHAR";
    public static String JDBC_VARCHAR = "VARCHAR";
    public static String JDBC_LONGVARCHAR = "LONGVARCHAR";
    public static String JDBC_BIT = "BIT";
    public static String JDBC_BOOLEAN = "BOOLEAN";
    public static String JDBC_BOOL = "BOOL";
    public static String JDBC_DECIMAL = "DECIMAL";
    public static String JDBC_NUMERIC = "NUMERIC";
    public static String JDBC_DOUBLE = "DOUBLE";
    public static String JDBC_FLOAT = "FLOAT";
    public static String JDBC_REAL = "REAL";
    public static String JDBC_INTEGER = "INTEGER";
    public static String JDBC_INT = "INT";
    public static String JDBC_SMALLINT = "SMALLINT";
    public static String JDBC_TINYINT = "TINYINT";
    public static String JDBC_BIGINT = "BIGINT";
    public static String JDBC_DATE = "DATE";
    public static String JDBC_TIME = "TIME";
    public static String JDBC_DATETIME = "DATETIME";
    public static String JDBC_TIMESTAMP = "TIMESTAMP";
    private static final Map<String, Integer> MAP_STRING = new HashMap<String, Integer>();
    private static final Map<String, Integer> MAP_BOOLEAN = new HashMap<String, Integer>();
    private static final Map<String, Integer> MAP_DECIMAL = new HashMap<String, Integer>();
    private static final Map<String, Integer> MAP_INTEGER = new HashMap<String, Integer>();
    private static final Map<String, Integer> MAP_DOUBLE = new HashMap<String, Integer>();
    private static final String[] TYPE_LIST_STRING = new String[]{JDBC_CHAR, JDBC_VARCHAR, JDBC_LONGVARCHAR};
    private static final String[] TYPE_LIST_BOOLEAN = new String[]{JDBC_BIT, JDBC_BOOLEAN, JDBC_BOOL};
    private static final String[] VALUE_LIST_BOOLEAN_TRUE = new String[]{"TRUE", "T", "YES", "Y", "1"};
    private static final String[] TYPE_LIST_DECIMAL = new String[]{JDBC_DECIMAL, JDBC_NUMERIC, JDBC_DOUBLE, JDBC_FLOAT, JDBC_REAL};
    private static final String[] TYPE_LIST_INTEGER = new String[]{JDBC_INTEGER, JDBC_INT, JDBC_SMALLINT, JDBC_TINYINT};

    private JDBCConverter() {
    }

    public static Object jdbcObjectConvert(Object sourceValue, String tgtJdbcType) {
        String tmp = JDBCConverter.object2String(sourceValue);
        Object targetValue = JDBCConverter.string2Object(tmp, tgtJdbcType);
        return targetValue;
    }

    private static Object string2Object(String value, String sqlTypeName) {
        try {
            return JDBCConverter._string2Object(value, sqlTypeName);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object _string2Object(String value, String sqlTypeName) throws ParseException {
        if (null == value) {
            return null;
        }
        if (JDBCConverter.isStringExistsIn(sqlTypeName, TYPE_LIST_STRING)) {
            return value;
        }
        value = value.trim();
        if (JDBCConverter.isStringExistsIn(sqlTypeName, TYPE_LIST_BOOLEAN)) {
            return JDBCConverter.isStringExistsIn(value, VALUE_LIST_BOOLEAN_TRUE);
        }
        if (JDBCConverter.isStringExistsIn(sqlTypeName, TYPE_LIST_DECIMAL)) {
            return new BigDecimal(value);
        }
        if (JDBC_BIGINT.equalsIgnoreCase(sqlTypeName)) {
            if (value.indexOf(46) >= 0) {
                return new BigDecimal(value).longValue();
            }
            return Long.valueOf(value);
        }
        if (JDBCConverter.isStringExistsIn(sqlTypeName, TYPE_LIST_INTEGER)) {
            if ("TRUE".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value)) {
                return "TRUE".equalsIgnoreCase(value) ? 1 : 0;
            }
            if (value.indexOf(46) >= 0) {
                return new BigDecimal(value).intValue();
            }
            return Integer.valueOf(value);
        }
        if (JDBC_DATE.equalsIgnoreCase(sqlTypeName)) {
            Date date = DateHelper.stdString2Date(value);
            assert (date != null);
            return new java.sql.Date(date.getTime());
        }
        if (JDBC_TIME.equalsIgnoreCase(sqlTypeName)) {
            Date time;
            try {
                time = DateHelper.stdString2Time(value);
            }
            catch (ParseException e) {
                time = DateHelper.stdString2Date(value);
            }
            if (null == time) {
                throw new RuntimeException("\u65e0\u6cd5\u6709\u6548\u5c06\u503c[" + value + "]\u89e3\u6790\u6210JDBC_TYPE:" + sqlTypeName);
            }
            return new Time(time.getTime());
        }
        if (JDBC_DATETIME.equalsIgnoreCase(sqlTypeName) || JDBC_TIMESTAMP.equalsIgnoreCase(sqlTypeName)) {
            Date date = DateHelper.stdString2Date(value);
            return new Timestamp(date.getTime());
        }
        return value;
    }

    private static boolean isStringExistsIn(String jdbcType, String[] strTypes) {
        return Arrays.binarySearch(strTypes, jdbcType.toUpperCase()) >= 0;
    }

    private static String object2String(Object value) {
        if (value instanceof java.sql.Date) {
            return DateHelper.date2String((Date)value, "yyyy/MM/dd Z");
        }
        if (value instanceof Time) {
            return DateHelper.date2String((Date)value, "HH:mm:ss.SSS Z");
        }
        if (value instanceof Date) {
            return DateHelper.date2String((Date)value, "yyyy/MM/dd HH:mm:ss.SSS Z");
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    static {
        Arrays.sort(TYPE_LIST_STRING);
        Arrays.sort(TYPE_LIST_BOOLEAN);
        Arrays.sort(VALUE_LIST_BOOLEAN_TRUE);
        Arrays.sort(TYPE_LIST_DECIMAL);
        Arrays.sort(TYPE_LIST_INTEGER);
        MAP_STRING.put(JDBC_CHAR, 1);
        MAP_STRING.put(JDBC_VARCHAR, 1);
        MAP_STRING.put(JDBC_LONGVARCHAR, 1);
        MAP_BOOLEAN.put(JDBC_BIT, 2);
        MAP_BOOLEAN.put(JDBC_BOOLEAN, 2);
        MAP_BOOLEAN.put(JDBC_BOOL, 2);
        MAP_DECIMAL.put(JDBC_DECIMAL, 3);
        MAP_DECIMAL.put(JDBC_NUMERIC, 3);
        MAP_INTEGER.put(JDBC_INTEGER, 4);
        MAP_INTEGER.put(JDBC_INT, 4);
        MAP_INTEGER.put(JDBC_SMALLINT, 4);
        MAP_INTEGER.put(JDBC_TINYINT, 4);
        MAP_DOUBLE.put(JDBC_DOUBLE, 5);
        MAP_DOUBLE.put(JDBC_FLOAT, 5);
        MAP_DOUBLE.put(JDBC_REAL, 5);
    }

    public static final class DateHelper {
        private static final Pattern END_WITH_TIMEZONE = Pattern.compile(".*\\s+([\\+|-][0-1]\\d00)$");
        private static final String[] STD_DATE_FORMATS = new String[]{"yyyy/M/d H:m:s.S Z", "yyyy/M/d H:m:s Z", "yyyy/M/d H:m Z", "yyyy/M/d Z"};
        private static final String[] STD_TIME_FORMATS = new String[]{"H:m:s.S Z", "H:m:s Z", "H:m Z"};

        private DateHelper() {
        }

        private static String splitTimeZone(String s) {
            Matcher m = END_WITH_TIMEZONE.matcher(s);
            if (m.matches()) {
                return m.group(1);
            }
            return null;
        }

        private static String getCurrTimeZone() {
            int offset = TimeZone.getDefault().getRawOffset();
            String wOrE = "";
            wOrE = offset > 0 ? "+" : "-";
            String timeZoneCode = String.valueOf(offset / 3600000);
            timeZoneCode = timeZoneCode.length() < 2 ? wOrE + "0" + timeZoneCode + "00" : wOrE + timeZoneCode + "00";
            return timeZoneCode;
        }

        private static Date _string2Date(String sDate, String fmt, String timeZone) {
            Date date;
            SimpleDateFormat ofmt = new SimpleDateFormat(fmt);
            try {
                date = ofmt.parse(sDate);
            }
            catch (ParseException e) {
                date = null;
            }
            return date;
        }

        public static Date stdString2Date(String dateString) throws ParseException {
            String sDate = dateString;
            if (null == sDate) {
                return null;
            }
            sDate = sDate.trim();
            String tz = DateHelper.splitTimeZone(sDate);
            String tm = sDate;
            if (null == tz) {
                tz = DateHelper.getCurrTimeZone();
            } else {
                tm = sDate.substring(0, sDate.length() - tz.length());
            }
            tm = tm.replace("-", "/");
            sDate = tm.trim() + " " + tz;
            for (String stdDateFormat : STD_DATE_FORMATS) {
                Date date = DateHelper._string2Date(sDate, stdDateFormat, tz);
                if (date == null) continue;
                return date;
            }
            return null;
        }

        public static Date stdString2Time(String timeString) throws ParseException {
            String sTime = timeString;
            if (null == sTime) {
                return null;
            }
            sTime = sTime.trim();
            String tz = DateHelper.splitTimeZone(sTime);
            String tm = sTime;
            if (null == tz) {
                tz = DateHelper.getCurrTimeZone();
            } else {
                tm = sTime.substring(0, sTime.length() - tz.length());
            }
            sTime = tm + " " + tz;
            for (String stdTimeFormat : STD_TIME_FORMATS) {
                Date time = DateHelper._string2Date(sTime, stdTimeFormat, tz);
                if (time == null) continue;
                return time;
            }
            throw new ParseException("Unparseable date: \"" + timeString + "\"", -1);
        }

        public static String date2String(Date date, String fmt) {
            return DateHelper.date2String(date, fmt, Locale.getDefault());
        }

        public static String date2String(Date date, String fmt, Locale loc) {
            return new SimpleDateFormat(fmt, loc).format(date);
        }
    }
}

