/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.coordinate.struct;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ThrottleConfig {
    private Duration step = Duration.ofSeconds(3L);
    private int maxCount = 10;
    private Duration maxStep = Duration.ofSeconds(10L);
    public static final ScheduledExecutorService delayedExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread th = new Thread(r);
        th.setDaemon(true);
        th.setName("SemaphoreThrottleDelayScheduler");
        return th;
    });
    private ScheduledExecutorService executor = delayedExecutor;

    public ThrottleConfig() {
    }

    public ThrottleConfig(Duration step, int maxCount, Duration maxStep, ScheduledExecutorService executor) {
        this.step = step;
        this.maxCount = maxCount;
        this.maxStep = maxStep;
        this.executor = executor;
    }

    public static ThrottleConfig throttle(Duration step, int maxCount, Duration maxStep) {
        return new ThrottleConfig(step, maxCount, maxStep, delayedExecutor);
    }

    public Duration getStep() {
        return this.step;
    }

    public void setStep(Duration step) {
        this.step = step;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public Duration getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Duration maxStep) {
        this.maxStep = maxStep;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }
}

