/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.coordinate.impl;

import com.bokesoft.distro.tech.commons.basis.coordinate.struct.Semaphore;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.ThrottleConfig;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class SimpleSemaphoreThrottle {
    final Duration step;
    final int maxCount;
    final Duration maxStep;
    final ScheduledExecutorService executor;
    private LocalDateTime lastTime;
    private int count;
    private LocalDateTime lastPostTime;
    private Semaphore nextSemaphore;
    private Consumer<Semaphore> nextAction;
    private ScheduledFuture nextFuture;

    public SimpleSemaphoreThrottle(ThrottleConfig config) {
        this(config.getStep(), config.getMaxCount(), config.getMaxStep(), config.getExecutor());
    }

    public SimpleSemaphoreThrottle(Duration step, int maxCount, Duration maxStep, ScheduledExecutorService executor) {
        this.step = step;
        this.maxCount = maxCount;
        this.maxStep = maxStep;
        this.executor = executor;
    }

    public synchronized void onFilter(Semaphore semaphore, Consumer<Semaphore> nextAction) {
        LocalDateTime prevTime = this.lastTime;
        this.lastTime = LocalDateTime.now();
        if (this.nextFuture != null) {
            this.nextFuture.cancel(false);
        }
        if (this.lastPostTime == null) {
            this.postRun(semaphore, nextAction);
            return;
        }
        if (this.lastPostTime.plus(this.maxStep).isBefore(semaphore.time)) {
            this.postRun(semaphore, nextAction);
            return;
        }
        if (++this.count >= this.maxCount) {
            this.postRun(semaphore, nextAction);
            return;
        }
        if (prevTime.plus(this.step).isBefore(this.lastTime)) {
            this.postRun(semaphore, nextAction);
            return;
        }
        this.nextAction = nextAction;
        this.nextSemaphore = semaphore;
        this.nextFuture = this.executor.schedule(this::delayRun, this.step.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void postRun(Semaphore semaphore, Consumer<Semaphore> nextAction) {
        this.count = 0;
        this.lastPostTime = LocalDateTime.now();
        this.nextSemaphore = null;
        this.nextAction = null;
        nextAction.accept(semaphore);
    }

    private synchronized void delayRun() {
        if (this.nextFuture.isCancelled() || this.nextAction == null || this.nextSemaphore == null) {
            return;
        }
        this.nextAction.accept(this.nextSemaphore);
    }
}

