package com.bokesoft.distro.tech.commons.basis.io.internal;

import java.time.LocalDate;

public class FolderExpiredCalcTool {
    private static final int MIN_VALID_YEAR = 2000;

    /**
     * 根据路径,按照 YYYY/MM/DD 格式解析路径有效时间
     * @param path
     * @return
     */
    public static LocalDate parseDateFromPath(String path) {
        if(null == path){
            path = "";
        }
        String[] parts = path.split("/");
        String partYear = parts.length>=1?parts[0]:null;
        String partMonth = parts.length>=2?parts[1]:null;
        String partDay = parts.length>=3?parts[2]:null;

        Integer year = parseYear(partYear);
        if ( null == year ){       //年份解析为无效,则返回最小年份的1月1日: 2000-01-01
            return toLocalDate(MIN_VALID_YEAR, 1, 1);
        }

        if ( null == partMonth ){  // 如果只有年,则返回当年最后一天
            return toLocalDate(year,12,31);
        }

        Integer month = parseMonth(partMonth);

        if ( null == month ){  //如果有年份,月份解析为无效,则返回当年的1月1日
            return toLocalDate(year,1,1);
        }

        if( null == partDay ){ // 如果只有年份、月份,则返回当年当月最后一天
            return toLocalDate(year,month,getMonthLastDay(year,month));
        }

        Integer day = parseDay( partDay, getMonthLastDay(year,month));

        if( null == day ){    // 如果有年份,月份,日解析为无效,则返回当年当月的1日
            return toLocalDate(year,month,1);
        }

        return toLocalDate( year, month, day ); //返回准确的年月日
    }

    private static LocalDate toLocalDate(int year, int month, int day) {
        return LocalDate.of(year,month,day);
    }

    private static Integer parseYear(String partYear) {
        Integer result = null;
        if(null != partYear){ //字符串不为空
            if(isInteger(partYear)) {
                result = Integer.parseInt(partYear);
                if (result < MIN_VALID_YEAR){ //数字年份, 也有可能是无效的
                    result = null;
                }
            }
        }
        return result;
    }

    private static Integer parseMonth(String partMonth) {
        Integer result = null;
        if(isInteger(partMonth)) {
            result = Integer.parseInt(partMonth);
            if (result < 1 || result > 12) {
                result = null;
            }
        }
        return result;
    }

    private static Integer parseDay(String partDay, int monthLastDay) {
        Integer result = null;
        if(isInteger(partDay)) {
            result = Integer.parseInt(partDay);
            if (result < 1 || result > monthLastDay) {
                result = null;
            }
        }
        return result;
    }

    private static int getMonthLastDay(int year, int month) {
        LocalDate tempDate = LocalDate.of(year, month, 1); // 先创建当月 1 号
        return tempDate.lengthOfMonth(); // 获取该月最大天数
    }

    private static boolean isInteger(String str) {
        // 判断是否为整数
        return str.matches("-?\\d+");
    }
}
