package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask;

import com.bokesoft.yigo.common.util.TypeConvertor;

import java.io.*;
import java.util.Map;

public class QuartzJobEvent implements Serializable {

    private long occurTime;
    private String jobName;
    private String jobGroup;
    private String jobClassName;
    private String erpClientID;
    private long taskOperatorID;

    /**
     * 注意,在ERP源码中,key='YigoClientID '
     * com.bokesoft.yes.erp.backgroundtask.IBackGroundTask.java
     */
    private String yigoClientID;
    private String formula;
    private String taskID;
    private String parameterFormula;
    private long currentOID;
    private long taskGroupID;

    /**
     * job是否已经执行过了
     */
    private boolean executed;
    private String error;
    private String operatorName;

    private long costMillis;

    public long getOccurTime() {
        return occurTime;
    }

    public void setOccurTime(long occurTime) {
        this.occurTime = occurTime;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getJobClassName() {
        return jobClassName;
    }

    public void setJobClassName(String jobClassName) {
        this.jobClassName = jobClassName;
    }

    public boolean isExecuted() {
        return executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErpClientID() {
        return erpClientID;
    }

    public void setErpClientID(String erpClientID) {
        this.erpClientID = erpClientID;
    }

    public long getTaskOperatorID() {
        return taskOperatorID;
    }

    public void setTaskOperatorID(long taskOperatorID) {
        this.taskOperatorID = taskOperatorID;
    }

    public String getYigoClientID() {
        return yigoClientID;
    }

    public void setYigoClientID(String yigoClientID) {
        this.yigoClientID = yigoClientID;
    }

    public String getFormula() {
        return formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getTaskID() {
        return taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public String getParameterFormula() {
        return parameterFormula;
    }

    public void setParameterFormula(String parameterFormula) {
        this.parameterFormula = parameterFormula;
    }

    public long getCurrentOID() {
        return currentOID;
    }

    public void setCurrentOID(long currentOID) {
        this.currentOID = currentOID;
    }

    public long getTaskGroupID() {
        return taskGroupID;
    }

    public void setTaskGroupID(long taskGroupID) {
        this.taskGroupID = taskGroupID;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public long getCostMillis() {
        return costMillis;
    }

    public void setCostMillis(long costMillis) {
        this.costMillis = costMillis;
    }

    public static void from(QuartzJobEvent event, Map<String,Object>data){
        event.setOccurTime(TypeConvertor.toLong(data.get("occurTime")));
        event.setJobName(TypeConvertor.toString(data.get("jobName")));
        event.setJobClassName(TypeConvertor.toString(data.get("jobClassName")));
        event.setJobGroup(TypeConvertor.toString(data.get("jobGroup")));
        event.setErpClientID(TypeConvertor.toString(data.get("erpClientID")));
        event.setTaskOperatorID(TypeConvertor.toLong(data.get("taskOperatorID")));
        event.setYigoClientID(TypeConvertor.toString(data.get("yigoClientID")));
        event.setFormula(TypeConvertor.toString(data.get("formula")));
        event.setTaskID(TypeConvertor.toString(data.get("taskID")));
        event.setParameterFormula(TypeConvertor.toString(data.get("parameterFormula")));
        event.setCurrentOID(TypeConvertor.toLong(data.get("currentOID")));
        event.setTaskGroupID(TypeConvertor.toLong(data.get("taskGroupID")));
        event.setExecuted(TypeConvertor.toBoolean(data.get("executed")));
        event.setError(TypeConvertor.toString(data.get("error")));
        event.setOperatorName(TypeConvertor.toString(data.get("operatorName")));
        event.setCostMillis(TypeConvertor.toLong(data.get("costMillis")));
    }

    public static void to(QuartzJobEvent e, Map<String,Object> data){
        data.put("occurTime", e.getOccurTime());
        data.put("jobName", e.getJobName());
        data.put("jobClassName", e.getJobClassName());
        data.put("jobGroup", e.getJobGroup());
        data.put("erpClientID", e.getErpClientID());
        data.put("taskOperatorID", e.getTaskOperatorID());
        data.put("yigoClientID", e.getYigoClientID());
        data.put("formula", e.getFormula());
        data.put("taskID", e.getTaskID());
        data.put("parameterFormula", e.getParameterFormula());
        data.put("currentOID", e.getCurrentOID());
        data.put("taskGroupID", e.getTaskGroupID());
        data.put("executed", e.isExecuted());
        data.put("error", e.getError());
        data.put("operatorName", e.getOperatorName());
        data.put("costMillis", e.getCostMillis());
    }

}