package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.app;

import java.io.Serializable;

public class AppHealthCheckEvent implements Serializable {
    private AppHealth status;

    private String reason;

    private long createTime;


    public AppHealth getStatus() {
        return status;
    }

    public void setStatus(AppHealth status) {
        this.status = status;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public static AppHealthCheckEvent build(AppHealth status, String reason,long timestamp) {
        AppHealthCheckEvent event = new AppHealthCheckEvent();
        event.status=status;
        event.reason=reason;
        event.createTime =timestamp;
        return event;
    }

    public AppHealthCheckEvent() {
    }

    @Override
    public String toString() {
        return "AppHealthCheckEvent{" +
                "status=" + status +
                ", reason='" + reason + '\'' +
                ", createTime=" + createTime +
                '}';
    }
}
