package com.bokesoft.distro.tech.commons.basis.flightrecord;

import com.bokesoft.distro.tech.commons.basis.flightrecord.config.FlightRecordToolsRegistry;
import com.bokesoft.distro.tech.commons.basis.flightrecord.impl.CacheDescProviderScanner;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.FlightRecordVO;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask.QuartzJobEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.ConnectionCloseEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.ConnectionOpenEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.DatasourceCfgEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache.CacheDescriptionDTO;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache.ClassBytePackageEvent;

import javax.sql.DataSource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应用系统调用, 记录各类监控信息
 */
public class FlightRecordFacade {
    public static void logConnectionCreate(String datasourceId, String connInstId){
        if(null != FlightRecordToolsRegistry.getRecorder()) {
            ConnectionOpenEvent event = ConnectionOpenEvent.build(datasourceId, connInstId);
            FlightRecordVO yfrVo = FlightRecordVO.buildBase();
            yfrVo.setConnectionOpenEvent(event);
            FlightRecordToolsRegistry.getRecorder().push(yfrVo);
        }
    }

    public static void logConnectionclose(String datasourceId, String connInstId){
        if(null != FlightRecordToolsRegistry.getRecorder()) {
            ConnectionCloseEvent event = ConnectionCloseEvent.build(datasourceId, connInstId);
            FlightRecordVO yfrVo = FlightRecordVO.buildBase();
            yfrVo.setConnectionCloseEvent(event);
            FlightRecordToolsRegistry.getRecorder().push(yfrVo);
        }
    }

    public static void logDatasourceCfg(DataSource dataSource){
        if(null != FlightRecordToolsRegistry.getRecorder()) {
            DatasourceCfgEvent event = DatasourceCfgEvent.build(dataSource);
            FlightRecordVO yfrVo = FlightRecordVO.buildBase();
            yfrVo.setDatasourceCfgEvent(event);
            FlightRecordToolsRegistry.getRecorder().push(yfrVo);
        }
    }

    public static void recordClassBytePackage(){
        if(null != FlightRecordToolsRegistry.getRecorder()) {
            List<CacheDescriptionDTO> cacheDescriptionDTOS = CacheDescProviderScanner.scanCacheDescriptions()
                    .stream().map(CacheDescriptionDTO::toDTO)
                    .collect(Collectors.toList());
            for (CacheDescriptionDTO dto : cacheDescriptionDTOS) {
                ClassBytePackageEvent event = ClassBytePackageEvent.build(dto);
                FlightRecordVO yfrVo = FlightRecordVO.buildBase();
                yfrVo.setClassBytePackageEvent(event);
                FlightRecordToolsRegistry.getRecorder().push(yfrVo);
            }
        }
    }

    public static void logBackgroundTask(QuartzJobEvent event) {
        if (null == FlightRecordToolsRegistry.getRecorder())
            return;
        FlightRecordVO yfrVo = FlightRecordVO.buildBase();
        yfrVo.setQuartzJobEvent(event);
        FlightRecordToolsRegistry.getRecorder().push(yfrVo);
    }

}
