package com.bokesoft.distro.tech.commons.basis.coordinate.intf;


import com.bokesoft.distro.tech.commons.basis.coordinate.struct.LeaderStatusConfig;

public interface ILeaderStatusDetector {


    /**
     * 判断业务节点是否主节点
     * @param tag 业务标识
     * @return 当前节点是否主节点
     */
    boolean isLeader(String tag);

    /**
     * 注册主节点探测器的配置,
     * @param tag  业务标识,不能重复
     * @param config 配置,注册后不可变
     */
    void register(String tag, LeaderStatusConfig config);

}
