package com.bokesoft.distro.tech.commons.basis.auth.crossauth;

import com.bokesoft.distro.tech.commons.basis.auth.CrossAuthUtil;

/**
 * {@link CrossAuthUtil} 处理的验证数据对象
 */
public class CrossAuthData {

    /** token - 身份验证的令牌 */
    private String token;
    /** callerId - Caller 标识(Caller 指需要授权验证的调用方) */
    private String callerId;
    /** 发起验证请求的时间(毫秒时间戳) */
    private long applyTime;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCallerId() {
        return callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public long getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(long applyTime) {
        this.applyTime = applyTime;
    }

    public static class Builder{
        private String token;
        private String callerId;
        private long applyTime;

        public Builder callerId(String callerId){
            this.callerId = callerId;
            return this;
        }

        public Builder token(String token){
            this.token = token;
            return this;
        }

        public Builder applyTime(long applyTime){
            this.applyTime = applyTime;
            return this;
        }

        public CrossAuthData build(){
            CrossAuthData request = new CrossAuthData();
            request.setToken(token);
            request.setCallerId(callerId);
            request.setApplyTime(applyTime);
            return request;
        }

    }
}
