package com.bokesoft.distro.tech.commons.basis.auth.annotation;

/**
 * 表示一个具体的权限校验规则。
 *
 * <p>该注解用于定义一个具体的权限字符串及对应的匹配策略，常用于与
 * {@link RequiresPermission} 配合使用。</p>
 */
public @interface PermissionCheck {
    /**
     * 权限标识，如 erp:customer:create, token:xxxxxx
     * @return 权限标识符，不能为空
     */
    String permission();

    /**
     * 校验策略类型，如 {@link Strategy#TOKEN}
     * @return
     */
    Strategy strategy();
}
