/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.wrapper;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.DefaultConnectionRecoveryFactory;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers.WarnOnlyConnectionRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.StartTimeObject;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoveryFactory;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.flags.IUnmanagedRecoverProcess;
import com.bokesoft.distro.tech.bootsupport.starter.wrapper.WrappedConnection;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IJDBCCompatible;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.YigoDBHelper;
import com.bokesoft.yes.mid.connection.IQueryColumnMetaData;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbcache.ICacheDBRequest;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import com.bokesoft.yigo.common.trace.intf.ITraceSupplier;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class WrappedDBManager
implements IDBManager,
IJDBCCompatible {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrappedDBManager.class);
    private static final IConnectionRecoveryFactory DEFAUL_RECOVERY_FACTORY = new DefaultConnectionRecoveryFactory();
    private IDBManager inner;
    private boolean execTimeoutControlEnabled;
    private StartTimeObject startTimeObject;
    private Level logLevel = Level.DEBUG;
    private IConnectionRecoveryFactory recoveryFactory = DEFAUL_RECOVERY_FACTORY;
    private List<IConnectionRecoverer> connectionRecoverers;

    public WrappedDBManager(IDBManager inner, String connectionInstanceId, boolean execTimeoutControlEnabled) {
        this.inner = inner;
        this.execTimeoutControlEnabled = execTimeoutControlEnabled;
        if (execTimeoutControlEnabled) {
            this.startTimeObject = StartTimeObject.buildTransactionStartTimeObject(connectionInstanceId);
            ExecutionTimeoutManager.addStartTimeObject(this.startTimeObject);
        }
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public void setRecoveryFactory(IConnectionRecoveryFactory recoveryFactory) {
        this.recoveryFactory = recoveryFactory;
    }

    public VE getVE() {
        return this.inner.getVE();
    }

    public void setVE(VE ve) {
        this.inner.setVE(ve);
    }

    public boolean checkViewExist(String s) throws Throwable {
        return this.inner.checkViewExist(s);
    }

    public boolean checkTableExist(String s) throws Throwable {
        return this.inner.checkTableExist(s);
    }

    public HashSet<String> getIndexSet(String s) throws Throwable {
        return this.inner.getIndexSet(s);
    }

    public String searchIndex(String s) throws Throwable {
        return this.inner.searchIndex(s);
    }

    public HashSet<String> getTableColumnSet(String s) throws Throwable {
        return this.inner.getTableColumnSet(s);
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        return this.inner.getColumnDef(metaSchemaColumn);
    }

    public String getAlterTableStr(MetaSchemaTable metaSchemaTable, List<MetaSchemaColumn> list) throws Throwable {
        return this.inner.getAlterTableStr(metaSchemaTable, list);
    }

    public String keyWordEscape(String s) {
        return this.inner.keyWordEscape(s);
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String s) {
        return this.inner.appendKeyWordEscape(stringBuilder, s);
    }

    public int getDBType() {
        return this.inner.getDBType();
    }

    public long getCurTime() throws Throwable {
        return this.inner.getCurTime();
    }

    public int getTimezoneOffset() throws Throwable {
        return this.inner.getTimezoneOffset();
    }

    public Object convert(Object o, int i, int i1) throws Throwable {
        return this.inner.convert(o, i, i1);
    }

    public int convertDataType(int i) {
        return this.inner.convertDataType(i);
    }

    public DataTable execPrepareQuery(String s, Object ... objects) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, objects)));
    }

    public DataTable execPrepareQuery(String s, IQueryColumnMetaData iQueryColumnMetaData, Object ... objects) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, iQueryColumnMetaData, objects)));
    }

    public DataTable execPrepareQuery(String s, List<Object> list) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, list)));
    }

    public DataTable execPrepareQuery(String s, IQueryColumnMetaData iQueryColumnMetaData, List<Object> list) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, iQueryColumnMetaData, list)));
    }

    public DataTable execPrepareQuery(String s, List<Integer> list, List<Object> list1) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, list, list1)));
    }

    public DataTable execPrepareQuery(String s, IQueryColumnMetaData iQueryColumnMetaData, List<Integer> list, List<Object> list1) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execPrepareQuery(s, iQueryColumnMetaData, list, list1)));
    }

    public DataTable execQuery(String s) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execQuery(s)));
    }

    public DataTable execQuery(String s, IQueryColumnMetaData iQueryColumnMetaData) throws Throwable {
        return this.queryDataTableWithTrace((ITraceSupplier<DataTable>)((ITraceSupplier)() -> this.inner.execQuery(s, iQueryColumnMetaData)));
    }

    public int execPrepareUpdate(String s, Object ... objects) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.execPrepareUpdate(s, objects)));
    }

    public int execPrepareUpdate(String s, List<Object> list) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.execPrepareUpdate(s, list)));
    }

    public int execPrepareUpdate(String s, List<Integer> list, List<Object> list1) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.execPrepareUpdate(s, list, list1)));
    }

    public int execUpdate(String s) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.execUpdate(s)));
    }

    public Statement createUpdateStatement() throws Throwable {
        return this.inner.createQueryStatement();
    }

    public Statement createQueryStatement() throws Throwable {
        return this.inner.createQueryStatement();
    }

    public PreparedStatement preparedQueryStatement(String s) throws Throwable {
        return this.inner.preparedQueryStatement(s);
    }

    public PreparedStatement preparedUpdateStatement(String s) throws Throwable {
        return this.inner.preparedUpdateStatement(s);
    }

    public ResultSet executeQuery(PreparedStatement preparedStatement, String s, QueryArguments queryArguments) throws Throwable {
        return this.queryResultSetWithTrace((ITraceSupplier<ResultSet>)((ITraceSupplier)() -> this.inner.executeQuery(preparedStatement, s, queryArguments)));
    }

    public int executeUpdate(PreparedStatement preparedStatement, String s, QueryArguments queryArguments) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.executeUpdate(preparedStatement, s, queryArguments)));
    }

    public void executeUpdate(BatchPsPara batchPsPara) throws Throwable {
        this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> {
            this.inner.executeUpdate(batchPsPara);
            return -1;
        }));
    }

    public ResultSet executeQuery(PsPara psPara, QueryArguments queryArguments) throws Throwable {
        return this.queryResultSetWithTrace((ITraceSupplier<ResultSet>)((ITraceSupplier)() -> this.inner.executeQuery(psPara, queryArguments)));
    }

    public int executeUpdate(PsPara psPara, QueryArguments queryArguments) throws Throwable {
        return this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> this.inner.executeUpdate(psPara, queryArguments)));
    }

    public String getConditionValue(int i, String s) {
        return this.inner.getConditionValue(i, s);
    }

    public String getLikeConditionValue(String s, int i, String s1) {
        return this.inner.getLikeConditionValue(s, i, s1);
    }

    public PrepareSQL getLimitString(String s, String s1, boolean b, int i, int i1) {
        return this.inner.getLimitString(s, s1, b, i, i1);
    }

    public PrepareSQL getCountString(String s) {
        return this.inner.getCountString(s);
    }

    public void rollback() throws SQLException {
        if (this.execTimeoutControlEnabled) {
            this.startTimeObject.setStartTime(System.currentTimeMillis());
        }
        this.inner.rollback();
    }

    public void commit() throws SQLException {
        if (this.execTimeoutControlEnabled) {
            this.startTimeObject.setStartTime(System.currentTimeMillis());
        }
        this.inner.commit();
    }

    public void close() throws SQLException {
        block3: {
            if (this.execTimeoutControlEnabled) {
                ExecutionTimeoutManager.removeStartTimeObject(this.startTimeObject);
            }
            boolean effected = this.applyRecovery();
            try {
                this.inner.close();
            }
            catch (Exception e) {
                if (effected) break block3;
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    public void setParameter(PreparedStatement preparedStatement, int i, Object o, int i1) throws SQLException, MidCoreException {
        this.inner.setParameter(preparedStatement, i, o, i1);
    }

    public void setRowLock(String s, String s1, Long aLong) throws Throwable {
        this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> {
            this.inner.setRowLock(s, s1, aLong);
            return 0;
        }));
    }

    public void setRowLock(String s, String s1, QueryArguments queryArguments) throws Throwable {
        this.updateWithTrace((ITraceSupplier<Integer>)((ITraceSupplier)() -> {
            this.inner.setRowLock(s, s1, queryArguments);
            return 0;
        }));
    }

    public void setRowLockEnsureInSYSLock(String s) throws Throwable {
        this.inner.setRowLockEnsureInSYSLock(s);
    }

    public IDBManager getNewDBManager() throws Throwable {
        return this.inner.getNewDBManager();
    }

    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        this.inner.initDataBaseInfo(dataBaseInfo);
    }

    public boolean saveDataTable(DataTable dataTable, String s, MetaTable metaTable, Object o) throws Throwable {
        return this.inner.saveDataTable(dataTable, s, metaTable, o);
    }

    public boolean saveDataTable(DataTable dataTable, String s, MetaTable metaTable) throws Throwable {
        return this.inner.saveDataTable(dataTable, s, metaTable);
    }

    public String getDBName() throws Throwable {
        return this.inner.getDBName();
    }

    public String getViewExistCheckSql() {
        return this.inner.getViewExistCheckSql();
    }

    public String getViewStructSql() {
        return this.inner.getViewStructSql();
    }

    public String getTableExistCheckSql() {
        return this.inner.getTableExistCheckSql();
    }

    public String getTableStructSql() {
        return this.inner.getTableStructSql();
    }

    public String getColumnCheckSql() {
        return this.inner.getColumnCheckSql();
    }

    public String getColumnStructSql() {
        return this.inner.getColumnStructSql();
    }

    public String getIndexStructSql() {
        return this.inner.getIndexStructSql();
    }

    public String getIndexSearchSql() {
        return this.inner.getIndexSearchSql();
    }

    public String getIndexCheckSql() {
        return this.inner.getIndexCheckSql();
    }

    public int[] executeUpdateReturn(BatchPsPara batchPsPara) throws Throwable {
        return this.inner.executeUpdateReturn(batchPsPara);
    }

    public int getTransactionID() {
        return this.inner.getTransactionID();
    }

    public Statement createJDBCStatement() throws SQLException {
        return this.inner.createJDBCStatement();
    }

    public Statement createJDBCPrepareStatement(String s) throws SQLException {
        return this.inner.createJDBCPrepareStatement(s);
    }

    public void setKey(String s) {
        this.inner.setKey(s);
    }

    public String getKey() {
        return this.inner.getKey();
    }

    private DataTable queryDataTableWithTrace(ITraceSupplier<DataTable> supplier) throws SQLException {
        try {
            return (DataTable)TraceSystemManager.withTraceLog(() -> (DataTable)supplier.get(), (Object)this, (boolean)true, (Logger)LOGGER, (Level)this.logLevel);
        }
        catch (Exception e) {
            this.prepareRecovery(e);
            return (DataTable)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private ResultSet queryResultSetWithTrace(ITraceSupplier<ResultSet> dbSupplier) throws SQLException {
        try {
            return (ResultSet)TraceSystemManager.withTraceLog(() -> (ResultSet)dbSupplier.get(), (Object)this, (boolean)true, (Logger)LOGGER, (Level)this.logLevel);
        }
        catch (Exception e) {
            this.prepareRecovery(e);
            return (ResultSet)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private Integer updateWithTrace(ITraceSupplier<Integer> dbSupplier) throws SQLException {
        try {
            return (Integer)TraceSystemManager.withTraceLog(() -> (Integer)dbSupplier.get(), (Object)this, (boolean)true, (Logger)LOGGER, (Level)this.logLevel);
        }
        catch (Exception e) {
            this.prepareRecovery(e);
            return (Integer)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Connection getRawConnection(IDBManager dbm) {
        try {
            if (dbm instanceof WrappedDBManager) {
                dbm = ((WrappedDBManager)dbm).inner;
            }
            if (dbm instanceof GeneralDBManager) {
                Connection conn = (Connection)FieldUtils.readField((Object)dbm, (String)"connection", (boolean)true);
                return WrappedDBManager.getRawConnection(conn);
            }
            throw new UnsupportedOperationException("\u65e0\u6cd5\u83b7\u53d6 DBManager '" + dbm.getClass().getName() + "' \u7684 connection \u5bf9\u8c61");
        }
        catch (IllegalAccessException e) {
            return (Connection)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Connection getRawConnection(Connection conn) {
        if (conn instanceof WrappedConnection) {
            WrappedConnection wrConn = (WrappedConnection)conn;
            Connection innerConn = wrConn.getInnerConnection();
            return WrappedDBManager.getRawConnection(innerConn);
        }
        return conn;
    }

    private boolean prepareRecovery(Exception e) throws SQLException {
        Connection conn;
        if (e instanceof SQLTimeoutException && !(conn = WrappedDBManager.getRawConnection(this)).isClosed()) {
            IConnectionRecoverer r = this.recoveryFactory.buildRecoverer(this.getDBType(), e);
            r.prepare(conn);
            this.appendConnectionRecoverers(r);
            LOGGER.error("\u53d1\u73b0 SQL \u6267\u884c\u8d85\u65f6, \u5c06\u4f7f\u7528 " + r.getClass().getName() + " \u8fdb\u884c\u6062\u590d\u5904\u7406", (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendConnectionRecoverers(IConnectionRecoverer r) {
        WrappedDBManager wrappedDBManager = this;
        synchronized (wrappedDBManager) {
            if (null == this.connectionRecoverers) {
                this.connectionRecoverers = new ArrayList<IConnectionRecoverer>();
            }
            this.connectionRecoverers.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyRecovery() {
        WrappedDBManager wrappedDBManager = this;
        synchronized (wrappedDBManager) {
            if (null == this.connectionRecoverers) {
                return false;
            }
            boolean managed = false;
            for (IConnectionRecoverer cr : this.connectionRecoverers) {
                if (cr instanceof IUnmanagedRecoverProcess) continue;
                managed = true;
                break;
            }
            if (managed) {
                return this.doManagedApplyRecovery();
            }
            return this.doApplyRecovery(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doManagedApplyRecovery() {
        boolean bl;
        DefaultContext newCtx = null;
        boolean effected = false;
        String connInfo = "\u672a\u521b\u5efa";
        try {
            newCtx = ContextBuilder.create();
            Connection newConn = WrappedDBManager.getRawConnection(newCtx.getDBManager());
            connInfo = WarnOnlyConnectionRecoverer.buildConnectionInfo(newConn);
            LOGGER.warn("\u6570\u636e\u5e93\u6062\u590d\u5904\u7406\u8fc7\u7a0b(Connection=[" + connInfo + "])\u5f00\u59cb ...");
            effected = this.doApplyRecovery(newConn);
            LOGGER.warn("\u6570\u636e\u5e93\u6062\u590d\u5904\u7406\u8fc7\u7a0b(Connection=[" + connInfo + "])\u5b8c\u6210.");
            bl = effected;
            if (null == newCtx) return bl;
        }
        catch (Throwable ex) {
            try {
                if (null != newCtx) {
                    try {
                        newCtx.rollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LOGGER.error("\u6570\u636e\u5e93\u6062\u590d\u5904\u7406\u8fc7\u7a0b(Connection=[" + connInfo + "])\u51fa\u9519: " + ex.getMessage(), ex);
                boolean bl2 = effected;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (null != newCtx) {
                    try {
                        newCtx.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            newCtx.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doApplyRecovery(Connection newConn) {
        WrappedDBManager wrappedDBManager = this;
        synchronized (wrappedDBManager) {
            if (null == this.connectionRecoverers || this.connectionRecoverers.isEmpty()) {
                return false;
            }
            for (IConnectionRecoverer cr : this.connectionRecoverers) {
                String recovererName = cr.getClass().getName();
                try {
                    cr.recover(newConn);
                    LOGGER.warn("\u6570\u636e\u5e93\u6062\u590d\u5904\u7406 {} \u6210\u529f\u5b8c\u6210.", (Object)recovererName);
                }
                catch (Exception ex) {
                    LOGGER.error("\u6570\u636e\u5e93\u6062\u590d\u5904\u7406 " + recovererName + " \u5931\u8d25: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return true;
        }
    }

    public Connection getConnection() throws SQLException {
        return YigoDBHelper.getConnection((IDBManager)this.inner);
    }

    public void begin() throws Throwable {
        this.inner.begin();
    }

    public int getMainVersion() throws Throwable {
        return this.inner.getMainVersion();
    }

    public ICacheDBRequest getCacheDBRequest() {
        return this.inner.getCacheDBRequest();
    }
}

