/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.filter;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoExtendJavascriptProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class YigoProjectExtendJSFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(YigoProjectExtendJSFilter.class);
    private final List<YigoExtendJavascriptProvider> providers;

    public YigoProjectExtendJSFilter(List<YigoExtendJavascriptProvider> providers) {
        this.providers = providers;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (null != this.providers && !this.providers.isEmpty()) {
            String originalJS;
            PatchTo200StatusContentResponseWrapper response = new PatchTo200StatusContentResponseWrapper(new ContentCachingResponseWrapper((HttpServletResponse)resp));
            IgnoreAcceptEncodingServletRequestWrapper request = new IgnoreAcceptEncodingServletRequestWrapper((HttpServletRequest)req);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-javascript;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (response.getRealStatus() == 200) {
                originalJS = new String(response.getContentAsByteArray(), "utf-8");
            } else {
                logger.warn("\u8bf7\u6c42\u7cfb\u7edf\u539f\u751fextend.js\u5931\u8d25, \u539f\u751fextend.js\u5c06\u88ab\u5ffd\u7565\u3002");
                originalJS = "";
            }
            response.resetBuffer();
            String js = this.buildExtendJS();
            PrintWriter printWriter = response.getWriter();
            printWriter.write(js);
            printWriter.write(System.lineSeparator());
            printWriter.write(System.lineSeparator());
            printWriter.write(this.wrapOriginalJS(originalJS));
            response.copyBodyToResponse();
        } else {
            chain.doFilter(req, resp);
        }
    }

    private String wrapOriginalJS(String originalJS) {
        return "/** \n * Build from static resource: yigo/project/extend.js\n * Created by: " + this.getClass().getSimpleName() + "(" + Base64.encodeToString((String)this.getClass().getName()) + ") \n */" + "\n" + "(function(){\n" + originalJS + "\n})();";
    }

    private String buildExtendJS() throws IOException {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("/** \n * Created by: " + this.getClass().getSimpleName() + "(" + Base64.encodeToString((String)this.getClass().getName()) + ") \n */");
        for (YigoExtendJavascriptProvider p : this.providers) {
            List<Resource> resources = p.getResources();
            if (resources == null || resources.isEmpty()) continue;
            for (Resource r : resources) {
                String head = "/** \n * " + r.getFilename() + "(" + Base64.encodeToString((String)r.getURL().toString()) + ")\n */";
                InputStream is = r.getInputStream();
                Throwable throwable = null;
                try {
                    String js = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    parts.add(head + '\n' + "(function(){\n" + js + "\n})();");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        return StringUtils.join(parts, (String)"\n\n");
    }

    static class PatchTo200StatusContentResponseWrapper
    extends HttpServletResponseWrapper {
        private final ContentCachingResponseWrapper responseWrapper;
        private int realStatus = -1;

        public PatchTo200StatusContentResponseWrapper(ContentCachingResponseWrapper response) {
            super((HttpServletResponse)response);
            this.responseWrapper = response;
        }

        public int getStatus() {
            return 200;
        }

        public void sendError(int sc) {
            this.realStatus = sc;
        }

        public void sendError(int sc, String msg) {
            this.realStatus = sc;
        }

        public void setStatus(int sc) {
            this.realStatus = sc;
        }

        public int getRealStatus() {
            return this.realStatus == -1 ? this.responseWrapper.getStatus() : this.realStatus;
        }

        public byte[] getContentAsByteArray() {
            return this.responseWrapper.getContentAsByteArray();
        }

        public void copyBodyToResponse() throws IOException {
            this.responseWrapper.copyBodyToResponse();
        }
    }

    static class IgnoreAcceptEncodingServletRequestWrapper
    extends HttpServletRequestWrapper {
        public IgnoreAcceptEncodingServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            if ("accept-encoding".equals(name)) {
                return null;
            }
            return super.getHeader(name);
        }
    }
}

