/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class SqlQueryCacheConfigurer {
    @Bean
    @ConditionalOnMissingBean
    public SqlQueryCache.RequestContext getRequestContext() {
        return new SqlQueryCache.RequestContext(){

            public SqlQueryCache.Request getRequest() {
                HttpServletRequest request = null;
                RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
                if (null != requestAttributes) {
                    request = ((ServletRequestAttributes)requestAttributes).getRequest();
                }
                if (null != request) {
                    return new HttpRequest(request);
                }
                return null;
            }
        };
    }

    @Lazy
    @Autowired
    public void setRequestContext(SqlQueryCache.RequestContext context) {
        SqlQueryCache.setRequestContext((SqlQueryCache.RequestContext)context);
    }

    public static class HttpRequest
    implements SqlQueryCache.Request {
        private HttpServletRequest request;

        public HttpRequest(HttpServletRequest request) {
            this.request = request;
        }

        public Object getAttribute(String key) {
            return this.request.getAttribute(key);
        }

        public void setAttribute(String key, Object value) {
            this.request.setAttribute(key, value);
        }
    }
}

