/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.event.YigoReloadRequestEvent;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class YigoInitStage2
implements ApplicationListener<ApplicationEvent> {
    private static Logger log = LoggerFactory.getLogger(YigoInitStage2.class);
    @Value(value="${server.port:-1}")
    int mainWebPort;
    @Autowired
    private YigoInstanceManager yigoInstanceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent appEvt) {
        ApplicationContext ctx;
        YigoReloadRequestEvent event;
        boolean reload = false;
        if (appEvt instanceof YigoReloadRequestEvent) {
            event = (YigoReloadRequestEvent)appEvt;
            ctx = event.getApplicationContext();
            reload = true;
            log.info("\u5f00\u59cb Yigo \u542f\u52a8(YigoReloadRequestEvent), ApplicationContext={} ...", (Object)ctx.getDisplayName());
        } else if (appEvt instanceof ContextRefreshedEvent) {
            event = (ContextRefreshedEvent)appEvt;
            ctx = event.getApplicationContext();
            if (!this.isMainWebContext(ctx)) {
                log.debug("\u5ffd\u7565\u975e\u5f53\u524d\u4e3b Web \u5e94\u7528\u7684 ApplicationContext {} .", (Object)ctx.getDisplayName());
                return;
            }
            log.info("\u5f00\u59cb Yigo \u542f\u52a8(Main ServletWebServerApplicationContext), ApplicationContext={} ...", (Object)ctx.getDisplayName());
        } else {
            log.debug("\u5ffd\u7565\u7684 ApplicationEvent: {} .", (Object)appEvt);
            return;
        }
        try {
            YigoInstanceManager.BOOTING_WITH_SPRING_BOOT = true;
            boolean isSilentStart = this.yigoInstanceManager.bootPrepare(ctx, reload);
            if (!isSilentStart) {
                this.yigoInstanceManager.bootLoad();
            }
        }
        catch (Exception ex) {
            log.error("Yigo \u542f\u52a8\u8fc7\u7a0b\u51fa\u9519\uff0c\u7cfb\u7edf\u9000\u51fa", (Throwable)ex);
            log.error("Yigo \u542f\u52a8\u8fc7\u7a0b\u51fa\u9519\uff0c\u7cfb\u7edf\u9000\u51fa: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            System.exit(SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> -1}));
        }
        finally {
            YigoInstanceManager.BOOTING_WITH_SPRING_BOOT = false;
        }
        log.info("Yigo \u542f\u52a8\u5b8c\u6210, ApplicationContext={} .", (Object)ctx.getDisplayName());
    }

    private boolean isMainWebContext(ApplicationContext ctx) {
        Assert.isTrue((this.mainWebPort != -1 ? 1 : 0) != 0, (String)"\u76ee\u524d\u5fc5\u987b\u501f\u52a9 server.port \u914d\u7f6e\u6765\u5224\u65ad\u4e3b\u670d\u52a1\u7aef\u53e3, \u6b64\u914d\u7f6e\u9879\u4e0d\u53ef\u7f3a\u5931");
        String ctxName = ctx.getDisplayName();
        if (!(ctx instanceof ServletWebServerApplicationContext)) {
            log.debug("\u5ffd\u7565\u975e ServletWebServerApplicationContext \u7c7b\u578b\u7684 ApplicationContext: {} .", (Object)ctxName);
            return false;
        }
        ServletWebServerApplicationContext webCtx = (ServletWebServerApplicationContext)ctx;
        WebServer webServer = webCtx.getWebServer();
        if (webServer == null) {
            log.info("webServer \u4e3a\u7a7a,\u5f53\u524d\u5e94\u7528\u8fd0\u884c\u5728war\u6a21\u5f0f\u4e0b .");
            return true;
        }
        int port = webServer.getPort();
        if (port == this.mainWebPort) {
            log.info("\u901a\u8fc7 {} \u7aef\u53e3\u5b9a\u4f4d\u5f53\u524d\u5e94\u7528\u7684\u4e3b Web ApplicationContext: {} .", (Object)port, (Object)ctxName);
            return true;
        }
        log.debug("\u5ffd\u7565\u7aef\u53e3({}) \u4e0d\u7b49\u4e8e {} \u7684 ApplicationContext: {} .", new Object[]{port, this.mainWebPort, ctxName});
        return false;
    }
}

