package com.bokesoft.distro.tech.bootsupport.starter.servlet;

import com.bokesoft.distro.tech.bootsupport.starter.utils.GlobalExceptionUtil;
import com.bokesoft.yes.common.trace.struct.EnforceLevel;
import com.bokesoft.yes.mid.servlet.AttachmentServlet;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExceptionHandlerAttachmentServlet extends AttachmentServlet {
    @Override
    public Object processService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        try {
            return super.processService(httpServletRequest, httpServletResponse);
        } catch (Throwable throwable) {
            // FIXME AttachmentServlet 需要在核心处理加上 TraceSystemManager.setEnforceMode
            TraceSystemManager.setEnforceMode();
            Throwable e = GlobalExceptionUtil.handleException(throwable);
            return ExceptionUtils.rethrow(e);
        }
    }
}
