package com.bokesoft.distro.tech.bootsupport.starter.i18n;

import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.i18n.LocaleStringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;

public class StringTable {
    /** yigo boot 模块词组key */
    public static final String MSG_GROUP = "YigoBoot";
    /** 词条:yigo不可用状态告警 */
    public static final String MSG_YIGO_STATUS_UNAVALIABLE = "YigoUnavaliableStatusMsg";
    /** 词条:yigo初始化状态告警 */
    public static final String MSG_YIGO_STATUS_UNREADY = "YigoUnreadyStatusMsg";
    /** 词条:只读数据库一致性检查失败 */
    public static final String MSG_DB_READONLY_CHECK_FAILD = "DBReadOnlyCheckFaild";
    /** 词条:只读数据库数据不一致 */
    public static final String MSG_DB_READONLY_UNCONSISTENCY = "DBReadOnlyUnConsistency";
    /** 词条:系统执行异常 */
    public static final String MSG_SYS_EXEC_ERROR = "SystemExecError";
    /** 词条:SqlServer同步异常 */
    public static final String MSG_SQLSERVER_RSYNC_ERROR = "SqlserverSyncError";
    /** 词条:SqlServer没有同步项 */
    public static final String MSG_SQLSERVER_RSYNC_MISS = "SqlserverSyncMiss";
    /** 词条:Mysql同步延迟异常 */
    public static final String MSG_MYSQL_RSYNC_DELAY = "MysqlRsyncDelay";
    /** 词条:Mysql同步IO异常 */
    public static final String MSG_MYSQL_RSYNC_IO_ERROR = "MysqlRsyncIOError";
    /** 词条:Mysql同步Sql执行异常 */
    public static final String MSG_MYSQL_RSYNC_SQL_ERROR = "MysqlRsyncSqlError";
    /** 词条:Mysql同步其他异常 */
    public static final String MSG_MYSQL_RSYNC_OTHER_ERROR = "MysqlRsyncOtherError";
    /** 词条:Watch数据为空 */
    public static final String MSG_WATCHDATA_IS_NULL = "WatchDataIsNull";

    private static LocaleStringTable stringTable = null;



    /**
     * 根据词条组,词条key，语言环境,获取对应语言的描述内容
     * @param locale 语言环境
     * @param group 词条组
     * @param key 词条key
     * @return
     */
    public static String getString(ILocale locale, String group, String key) {
        String string = null;
        if (stringTable == null) {
            stringTable = new LocaleStringTable(StringTable.class);
        }
        string =  stringTable.getString(locale, MSG_GROUP, key);
        return string;
    }

    /**
     * 根据词条key,语言环境,固化使用 YigoBoot 的词条组,获取对应语言的模板,并填充内容
     * @param locale
     * @param key
     * @param args
     * @return
     */
    public static String i18N(ILocale locale, String key,Object... args){
        String result = null;
        result = SimpleStringFormat.format(
                getString(null, MSG_GROUP, key),
                args,0);
        return result;
    }
}
