package com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers;

import java.sql.Connection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.flags.IUnmanagedRecoverProcess;

/**
 * 一个仅仅包含警告的 {@link IConnectionRecoverer}
 */
public class WarnOnlyConnectionRecoverer implements IConnectionRecoverer, IUnmanagedRecoverProcess {
    private static final Logger LOG = LoggerFactory.getLogger(WarnOnlyConnectionRecoverer.class);
    private String connInfo;

    @Override
    public void prepare(Connection connection) {
        this.connInfo = buildConnectionInfo(connection);
        LOG.warn("数据库问题恢复 - 发现存在问题的 Connection 对象: {}", this.connInfo);
    }

    @Override
    public void recover(Connection anotherConnection) {
        LOG.error("数据库问题恢复 - 未合理处理存在问题的 Connection 对象: {}", this.connInfo);
    }
    
    public static String buildConnectionInfo(Connection c){
        String result = c.toString();
        String clsName = c.getClass().getName();
        if (! result.contains(clsName)){
            result = clsName + ": " + result;
        }
        return result;
    }
}
