package com.bokesoft.distro.tech.bootsupport.starter.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix = "yigoee.tech.bootsupport.dbtrace")
@Component
public class DBTraceCacheConfig {
    /** 是否开启db调用trace的缓存记录 */
    private String enabled;
    /** 错误日志输出db调用记录的间隔时间设置 */
    private long intervalMs = 300_000;

    public String isEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public long getIntervalMs() {
        return intervalMs;
    }

    public void setIntervalMs(long intervalMs) {
        this.intervalMs = intervalMs;
    }
}
