package com.bokesoft.distro.tech.bootsupport.starter.auth.strage.impl;

import com.bokesoft.distro.tech.bootsupport.starter.auth.strage.PermissionCheckerStrategy;
import com.bokesoft.distro.tech.yigosupport.extension.auth.CrossAuthHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * 通过从 {@link HttpServletRequest} 获取token值,并校验是否具有权限
 */
@Component
public class TokenPermissionChecker implements PermissionCheckerStrategy {

    private static final Logger logger = LoggerFactory.getLogger(TokenPermissionChecker.class);

    @Override
    public boolean hasPermission(String permission) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            return CrossAuthHelper.doAuth(request);
        } catch (Throwable e) {
            logger.error("TokenPermissionChecker.hasPermission error:", e);
            return false;
        }
    }
}
