package com.bokesoft.distro.tech.bootsupport.starter.auth.crossauth;

import com.bokesoft.distro.tech.commons.basis.auth.crossauth.CrossAuthTokenSetting;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties(prefix = "yigoee.tech.bootsupport.auth.cross-auth")
public class CrossAuthConfig {
    private List<CallerAuthSetting> settings;

    public List<CallerAuthSetting> getSettings() {
        return settings;
    }

    public void setSettings(List<CallerAuthSetting> settings) {
        this.settings = settings;
    }

    public static class CallerAuthSetting {
        /** 对应 callerid 匹配字符串 */
        private String callerIdPattern;

        /** token 匹配配置 */
        private CrossAuthTokenSetting setting;

        public String getCallerIdPattern() {
            return callerIdPattern;
        }

        public void setCallerIdPattern(String callerIdPattern) {
            this.callerIdPattern = callerIdPattern;
        }

        public CrossAuthTokenSetting getSetting() {
            return setting;
        }

        public void setSetting(CrossAuthTokenSetting setting) {
            this.setting = setting;
        }
    }
}
