/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.wrapper;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.StartTimeObject;
import com.bokesoft.distro.tech.bootsupport.starter.utils.ServletUtil;
import com.bokesoft.distro.tech.commons.basis.flightrecord.FlightRecordFacade;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WrappedConnection
implements Connection {
    public static Map<Connection, String> dbTraceCache = new ConcurrentHashMap<Connection, String>();
    private Connection inner;
    private String datasourceid;
    private String instanceId;
    private String trace;
    private boolean dbTraceCacheEnabled;
    private boolean execTimeoutControlEnabled;

    public WrappedConnection(String datasourceid, Connection conn, String instanceId, boolean dbTraceCacheEnabled, boolean execTimeoutControlEnabled) {
        this.inner = conn;
        this.instanceId = instanceId;
        this.datasourceid = datasourceid;
        this.dbTraceCacheEnabled = dbTraceCacheEnabled;
        if (dbTraceCacheEnabled) {
            this.trace = this.buildThreadTrace(Thread.currentThread());
            dbTraceCache.put(this, this.trace);
        }
        this.execTimeoutControlEnabled = execTimeoutControlEnabled;
        FlightRecordFacade.logConnectionCreate((String)datasourceid, (String)instanceId);
    }

    private String buildThreadTrace(Thread currentThread) {
        StringBuffer sb = new StringBuffer("Thread[" + currentThread.getName() + "," + currentThread.getId() + "];");
        sb.append("\n");
        this.buildTraceInfo(sb);
        int limit = 50;
        for (StackTraceElement traceElement : currentThread.getStackTrace()) {
            if (limit > 0) {
                sb.append(traceElement.getClassName() + ":" + traceElement.getMethodName() + "#" + traceElement.getLineNumber());
                sb.append(";\n");
            }
            --limit;
        }
        return sb.toString();
    }

    private void buildTraceInfo(StringBuffer sb) {
        sb.append("TraceId:" + TraceRecorder.getTraceId() + " .");
        sb.append("\n");
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes && requestAttributes instanceof ServletRequestAttributes) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            String servletPath = ServletUtil.getFullServletPath(request);
            sb.append("request servlet path:" + servletPath + " .");
            sb.append("\n");
            String headInfoStr = request.getParameter("headinfos");
            sb.append("request headinfos:" + headInfoStr + " .");
            sb.append("\n");
        }
    }

    public Connection getInnerConnection() {
        return this.inner;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.inner.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.inner.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stat = this.inner.createStatement();
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stat = this.inner.prepareCall(sql);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.inner.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.inner.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.inner.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.inner.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.inner.rollback();
    }

    @Override
    public void close() throws SQLException {
        if (this.dbTraceCacheEnabled) {
            dbTraceCache.remove(this);
        }
        FlightRecordFacade.logConnectionclose((String)this.datasourceid, (String)this.instanceId);
        this.inner.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.inner.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.inner.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.inner.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.inner.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.inner.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.inner.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.inner.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.inner.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.inner.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.inner.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stat = this.inner.createStatement(resultSetType, resultSetConcurrency);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stat = this.inner.prepareCall(sql, resultSetType, resultSetConcurrency);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.inner.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.inner.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.inner.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.inner.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.inner.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.inner.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.inner.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.inner.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stat = this.inner.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stat = this.inner.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql, autoGeneratedKeys);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql, columnIndexes);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stat = this.inner.prepareStatement(sql, columnNames);
        this.setQueryTimeout(stat);
        return stat;
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.inner.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.inner.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.inner.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.inner.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.inner.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.inner.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.inner.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.inner.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.inner.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.inner.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.inner.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.inner.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.inner.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.inner.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.inner.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.inner.getNetworkTimeout();
    }

    private void setQueryTimeout(Statement stat) throws SQLException {
        if (this.execTimeoutControlEnabled) {
            stat.setQueryTimeout(this.getDBExecutionTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDBExecutionTimeout() {
        StartTimeObject startTimeObject = null;
        try {
            startTimeObject = StartTimeObject.buildSqlExectionStartTimeObject();
            ExecutionTimeoutManager.addStartTimeObject(startTimeObject);
            long dbExecutionTimeout = ExecutionTimeoutManager.allocRemainedTime(this.instanceId);
            int n = (int)Math.ceil(dbExecutionTimeout / 1000L);
            return n;
        }
        finally {
            ExecutionTimeoutManager.removeStartTimeObject(startTimeObject);
        }
    }
}

