/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoCoreConfig;
import com.bokesoft.distro.tech.bootsupport.starter.datasource.DataSourceConfig;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

public class YigoPropPreparation {
    private static final String PROPERTY_RESOURCES = "yigo2-distro.props-preparation.resources";
    private static final String PROPERTY_VAR_TYPES = "yigo2-distro.props-preparation.variable-types";
    private static final String PROPERTY_VAR_TYPE_PATH = "path";

    public static YigoPropPreparationHelper.PrepareResult doPrepare(ApplicationContext appCtx) {
        final Environment env = appCtx.getEnvironment();
        List<String> varsAsPath = YigoPropPreparation.readAsList(env, "yigo2-distro.props-preparation.variable-types.path");
        YigoPropPreparationHelper.setPathVariableList(varsAsPath);
        YigoPropPreparationHelper.setValueProvider(new YigoPropPreparationHelper.ValueProvider(){

            @Override
            public String getValue(String variable) {
                return env.getProperty(variable);
            }
        });
        try {
            Map configerBeans = appCtx.getBeansOfType(YigoRawConfiger.class);
            ArrayList<YigoRawConfiger> configers = new ArrayList<YigoRawConfiger>(configerBeans.values());
            List<String> resources = YigoPropPreparation.readAsList(env, PROPERTY_RESOURCES);
            YigoCoreConfig yigoCoreConfig = (YigoCoreConfig)appCtx.getBean(YigoCoreConfig.class);
            DataSourceConfig dataSourceConfig = (DataSourceConfig)appCtx.getBean(DataSourceConfig.class);
            return YigoPropPreparationHelper.prepare((ResourceLoader)appCtx, resources, configers, yigoCoreConfig, dataSourceConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> readAsList(Environment env, String key) {
        String propKey;
        String resource;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (null != (resource = env.getProperty(propKey = key + "[" + i + "]"))) {
            list.add(resource);
            ++i;
        }
        return list;
    }
}

