/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.readonly.impl;

import com.bokesoft.distro.tech.bootsupport.starter.config.ReadOnlyDbCheckConfig;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.intf.IDBWatcher;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBReadOnlyStatus;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBWatchData;
import com.bokesoft.distro.tech.commons.basis.trace.TraceUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDBWatcher
implements IDBWatcher {
    private static final Logger logger = LoggerFactory.getLogger(MySQLDBWatcher.class);

    @Override
    public DBWatchData doCheck(DefaultContext context, ReadOnlyDbCheckConfig config) throws Throwable {
        String sql = "show slave status";
        IDBManager dbManager = context.getDBManager();
        DataTable dt = dbManager.execPrepareQuery(sql, new Object[0]);
        MysqlDBWatchData mysqlDBWatchData = null;
        mysqlDBWatchData = dt.size() != 0 ? new MysqlDBWatchData(dt, config.getReplicationDelayThresholdS()) : MysqlDBWatchData.ERROR(this.dbErrI18N());
        return new DBWatchData(mysqlDBWatchData.getReason(), mysqlDBWatchData.getDescription(), mysqlDBWatchData.getStatus());
    }

    @Override
    public boolean support(int dbType) {
        return 4 == dbType;
    }

    private String dbErrI18N() {
        return StringTable.i18N(null, "DBReadOnlyCheckFaild", TraceUtil.getTraceId());
    }

    static class MysqlDBWatchData {
        private String masterHost = "unkown";
        private int masterPort = -1;
        private String masterLogFile = "unkown";
        private int readMasterLogPos = -1;
        private String relayLogFile = "unkown";
        private int relayLogPos = -1;
        private int execMasterLogPos = -1;
        private String slaveIOState = "unkown";
        private String slaveSQLRunningState = "unkown";
        private int lastIOErrno = -1;
        private String lastIOError = "unkown";
        private String lastIOErrorTimestamp = "unkown";
        private int lastSQLErrno = -1;
        private String lastSQLError = "unkown";
        private String lastSQLErrorTimestamp = "unkown";
        private int secondsBehindMaster = -1;
        private int delayThreshold = -1;
        private String reason;
        private DBReadOnlyStatus status = DBReadOnlyStatus.ERROR;

        private MysqlDBWatchData() {
        }

        public MysqlDBWatchData(DataTable dt, int delayThreshold) throws SQLException {
            this.slaveIOState = dt.getString("Slave_IO_Running");
            this.slaveSQLRunningState = dt.getString("Slave_SQL_Running");
            this.masterHost = dt.getString("Master_Host");
            this.masterPort = dt.getInt("Master_Port");
            this.masterLogFile = dt.getString("Master_Log_File");
            this.readMasterLogPos = dt.getInt("Read_Master_Log_Pos");
            this.relayLogFile = dt.getString("Relay_Log_File");
            this.relayLogPos = dt.getInt("Relay_Log_Pos");
            this.execMasterLogPos = dt.getInt("Exec_Master_Log_Pos");
            this.lastIOErrno = dt.getInt("Last_IO_Errno");
            this.lastIOError = dt.getString("Last_IO_Error");
            this.lastIOErrorTimestamp = dt.getString("Last_IO_Error_Timestamp");
            this.lastSQLErrno = dt.getInt("Last_SQL_Errno");
            this.lastSQLError = dt.getString("Last_SQL_Error");
            this.lastSQLErrorTimestamp = dt.getString("Last_SQL_Error_Timestamp");
            this.secondsBehindMaster = dt.getInt("Seconds_Behind_Master");
            this.delayThreshold = delayThreshold;
            if (this.slaveSQLRunningState.equalsIgnoreCase("yes") && this.slaveIOState.equalsIgnoreCase("yes")) {
                if (this.secondsBehindMaster > delayThreshold) {
                    this.status = DBReadOnlyStatus.ERROR;
                    this.reason = this.i18N4RsyncDelay();
                } else {
                    this.status = DBReadOnlyStatus.OK;
                }
            } else {
                this.status = DBReadOnlyStatus.ERROR;
                this.reason = StringUtils.isNotBlank((CharSequence)this.lastIOError) ? this.i18N4RsyncIOError() : (StringUtils.isNotBlank((CharSequence)this.lastSQLError) ? this.i18N4RsyncSqlError() : this.i18N4RsyncOtherError());
            }
        }

        public String getReason() {
            return this.reason;
        }

        public DBReadOnlyStatus getStatus() {
            return this.status;
        }

        public String getDescription() {
            String result = "\n=====================================================\n";
            result = result + "master sever: " + this.masterHost + ":" + this.masterPort + "\n";
            result = result + "slave status: " + (Object)((Object)this.status) + "\n";
            result = result + "error reason:" + this.reason + "\n";
            result = result + "masterLogFile: " + this.masterLogFile + ", readMasterLogPos: " + this.readMasterLogPos + " \n";
            result = result + "relayLogFile: " + this.relayLogFile + ", relayLogPos: " + this.relayLogPos + ", execMasterLogPos: " + this.execMasterLogPos + " \n";
            result = result + "slaveIOState: " + this.slaveIOState + "\n";
            result = result + "slaveSQLRunningState: " + this.slaveSQLRunningState + ", secondsBehindMaster: " + this.secondsBehindMaster + "\n";
            result = result + "lastIOErrno: " + this.lastIOErrno + ", lastIOErrorTimestamp: " + this.lastIOErrorTimestamp + "\n";
            result = result + "lastIOError: " + this.lastIOError + "\n";
            result = result + "lastSQLErrno: " + this.lastSQLErrno + ", lastSQLErrorTimestamp: " + this.lastSQLErrorTimestamp + "\n";
            result = result + "lastSQLError: " + this.lastSQLError + "\n";
            result = result + "=====================================================";
            return result;
        }

        public static MysqlDBWatchData ERROR(String reason) {
            MysqlDBWatchData data = new MysqlDBWatchData();
            data.reason = reason;
            return data;
        }

        private String i18N4RsyncDelay() {
            return StringTable.i18N(null, "MysqlRsyncDelay", this.delayThreshold, this.secondsBehindMaster, TraceUtil.getSpanId());
        }

        private String i18N4RsyncIOError() {
            return StringTable.i18N(null, "MysqlRsyncIOError", this.lastIOErrorTimestamp, this.lastIOError, TraceUtil.getSpanId());
        }

        private String i18N4RsyncSqlError() {
            return StringTable.i18N(null, "MysqlRsyncSqlError", this.lastSQLErrorTimestamp, this.lastSQLError, TraceUtil.getSpanId());
        }

        private String i18N4RsyncOtherError() {
            return StringTable.i18N(null, "MysqlRsyncOtherError", TraceUtil.getSpanId());
        }
    }
}

