/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.plugins;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.StorageUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.file.service.DownloadExcelService;
import com.bokesoft.yes.mid.file.service.ExportFileService;
import com.bokesoft.yes.mid.ver.SystemInfo;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"distro.tech.bootsupport.plugin.export.enabled"}, havingValue="true", matchIfMissing=false)
public class ExportFileThenDownloadExcelRedirectPlugin
implements YigoAdditionalInitiator {
    @Override
    public void init(DefaultContext context) {
        ExportFileServiceExt ee = new ExportFileServiceExt();
        DownloadExcelServiceEx de = new DownloadExcelServiceEx();
        ServiceProviderFactory.registerProvider((Object[][])new Object[][]{{ee.getServiceName(), ee}, {de.getServiceName(), de}});
    }

    public static class DownloadExcelServiceEx
    extends DownloadExcelService {
        protected IServiceCmd<DefaultContext> getDefaultImpl() {
            final IServiceCmd defaultImpl = super.getDefaultImpl();
            return new IServiceCmd<DefaultContext>(){

                public void dealArguments(DefaultContext ctx, StringHashMap<Object> args) throws Throwable {
                    String fileId = (String)args.get((Object)"filePath");
                    String fileName = (String)args.get((Object)"fileName");
                    String formKey = (String)args.get((Object)"formKey");
                    File temp = File.createTempFile(fileId, "." + fileName);
                    byte[] bytes = StorageUtil.readFile((DefaultContext)ctx, (String)formKey, (String)fileId);
                    FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
                    args.put((Object)"filePath", (Object)temp.getCanonicalPath());
                    defaultImpl.dealArguments((IServiceContext)ctx, args);
                }

                public Object doCmd(DefaultContext ctx) throws Throwable {
                    return defaultImpl.doCmd((IServiceContext)ctx);
                }

                public IServiceCmd<DefaultContext> newInstance() {
                    return this;
                }

                public void checkSecurity(IServiceProvider<DefaultContext> provider, DefaultContext ctx, String cmd, StringHashMap<Object> args) throws Throwable {
                    defaultImpl.checkSecurity(provider, (IServiceContext)ctx, cmd, args);
                }

                public String getCmd() {
                    return defaultImpl.getCmd();
                }
            };
        }

        public IServiceProvider<DefaultContext> newInstance() {
            return new DownloadExcelServiceEx();
        }
    }

    public static class ExportFileServiceExt
    extends ExportFileService {
        public Object process(DefaultContext ctx, String cmd, StringHashMap<Object> arguments) throws Throwable {
            Object origRes = super.process(ctx, cmd, arguments);
            int yigoversion = Integer.parseInt(SystemInfo.getBuildID());
            if (yigoversion < 20220905) {
                MiscUtil.$assert((!(origRes instanceof JSONObject) ? 1 : 0) != 0, (String)("\u4e0d\u652f\u6301\u7684 Cmd '" + cmd + "': \u8fd4\u56de\u7684\u6570\u636e\u5bf9\u8c61\u7c7b\u578b('" + origRes.getClass() + "')\u4e0d\u662f JSONObject"));
                JSONObject json = (JSONObject)origRes;
                String filePath = json.getString("filePath");
                MiscUtil.$assert((null == filePath ? 1 : 0) != 0, (String)("\u4e0d\u652f\u6301\u7684 Cmd '" + cmd + "': \u8fd4\u56de\u7684\u6570\u636e\u4e0d\u5305\u542b filePath"));
                File xlsPath = new File(filePath);
                long SOID = TypeConvertor.toLong((Object)arguments.get((Object)"OID"));
                filePath = StorageUtil.writeFile((DefaultContext)ctx, (String)json.getString("fileName"), (String)json.getString("formKey"), (long)SOID, (String)"", (String)"EXCEL", (File)xlsPath);
                json.put("filePath", (Object)filePath);
            } else {
                MiscUtil.$assert((!(origRes instanceof FileData) ? 1 : 0) != 0, (String)("\u4e0d\u652f\u6301\u7684 Cmd '" + cmd + "': \u8fd4\u56de\u7684\u6570\u636e\u5bf9\u8c61\u7c7b\u578b('" + origRes.getClass() + "')\u4e0d\u662f com.bokesoft.yes.struct.filedata.FileData"));
                FileData fileData = (FileData)origRes;
                long SOID = TypeConvertor.toLong((Object)arguments.get((Object)"OID"));
                String filePath = StorageUtil.writeFile((DefaultContext)ctx, (String)fileData.getFileName(), (String)arguments.get((Object)"formKey").toString(), (long)SOID, (String)"", (String)"EXCEL", (byte[])fileData.getData());
                fileData.setPath(filePath);
            }
            return origRes;
        }

        public IServiceProvider<DefaultContext> newInstance() {
            return new ExportFileServiceExt();
        }
    }
}

