/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.filter;

import com.bokesoft.distro.tech.bootsupport.starter.config.YigoInstanceReadyConfig;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.distro.tech.bootsupport.starter.utils.ServletUtil;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.Wildcard;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YigoInstanceReadyFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(YigoInstanceReadyFilter.class);
    private final String pcWaitingPage;
    private final String mobileWaitingPage;
    private final YigoInstanceManager yigoInstanceManager;
    private final YigoInstanceReadyConfig yigoInstanceReadyConfig;
    private static final Map<String, Boolean> independUrlsCache = new ConcurrentHashMap<String, Boolean>();

    public YigoInstanceReadyFilter(YigoInstanceManager yigoInstanceManager, String pcWaitingPage, String mobileWaitingPage, YigoInstanceReadyConfig yigoInstanceReadyConfig) {
        this.yigoInstanceManager = yigoInstanceManager;
        this.pcWaitingPage = pcWaitingPage;
        this.mobileWaitingPage = mobileWaitingPage;
        this.yigoInstanceReadyConfig = yigoInstanceReadyConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InstanceStatus is;
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        String url = httpReq.getServletPath();
        if (!this.isIndependUrl(url) && !(is = this.yigoInstanceManager.getInstanceStatus()).getStatus().equals((Object)InstanceStatus.Status.READY)) {
            if (this.yigoInstanceReadyConfig.getAppPcPageUrls().contains(url)) {
                httpReq.getRequestDispatcher(this.pcWaitingPage).forward(request, response);
                return;
            }
            if (this.yigoInstanceReadyConfig.getAppMobilePageUrls().contains(url)) {
                httpReq.getRequestDispatcher(this.mobileWaitingPage).forward(request, response);
                return;
            }
            if (is.getStatus().equals((Object)InstanceStatus.Status.ERROR) || is.getStatus().equals((Object)InstanceStatus.Status.UNAVALIABLE)) {
                logger.error("Yigo \u5e94\u7528\u76ee\u524d\u5904\u4e8e{}\u72b6\u6001, \u539f\u56e0:'{}', '{}' \u8bf7\u6c42\u5c06\u76f4\u63a5\u8fd4\u56de 500", new Object[]{is.getStatus(), is.getMessage(), ServletUtil.getFullServletPath(httpReq)});
                ILocale locale = this.getLocaleByCookie(httpReq);
                String errMsg = SimpleStringFormat.format((String)StringTable.getString(locale, "YigoBoot", "YigoUnavaliableStatusMsg"), (Object[])new Object[]{is.getStatus(), is.getMessage()});
                this.sendError(httpResp, "-1", errMsg);
                return;
            }
            logger.warn("Yigo \u5e94\u7528\u672a\u521d\u59cb\u5316\u5b8c\u6210,\u72b6\u6001:{}, '{}' \u8bf7\u6c42\u5c06\u76f4\u63a5\u8fd4\u56de 500", (Object)is.getStatus(), (Object)ServletUtil.getFullServletPath(httpReq));
            ILocale locale = this.getLocaleByCookie(httpReq);
            String errMsg = SimpleStringFormat.format((String)StringTable.getString(locale, "YigoBoot", "YigoUnreadyStatusMsg"), (Object[])new Object[]{is.getStatus()});
            this.sendError(httpResp, "-1", errMsg);
            return;
        }
        chain.doFilter(request, response);
    }

    private ILocale getLocaleByCookie(HttpServletRequest httpReq) {
        Cookie[] cookies = httpReq.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("locale")) continue;
                final String localeStr = cookie.getValue();
                return new ILocale(){

                    public String getLocale() {
                        return localeStr;
                    }
                };
            }
        }
        return null;
    }

    private void sendError(HttpServletResponse httpResp, String errCode, String errMsg) throws IOException {
        JSONObject json = new JSONObject();
        json.put("error_info", (Object)errMsg);
        json.put("error_code", (Object)errCode);
        httpResp.setCharacterEncoding("UTF-8");
        httpResp.setContentType("application/json;charset=UTF-8");
        httpResp.setStatus(500);
        httpResp.getWriter().write(json.toString());
    }

    private boolean isIndependUrl(String url) {
        boolean result = independUrlsCache.computeIfAbsent(url, testUrl -> {
            List<String> indepUrls = this.yigoInstanceReadyConfig.getYigoIndepUrls();
            if (null != indepUrls && !indepUrls.isEmpty()) {
                for (String urlPattern : indepUrls) {
                    if (!Wildcard.match((CharSequence)testUrl, (CharSequence)urlPattern)) continue;
                    return true;
                }
            }
            return false;
        });
        return result;
    }
}

