/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.deployment;

import com.bokesoft.distro.tech.bootsupport.starter.utils.URLPathUtils;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jodd.util.Wildcard;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SpringResourceIO
implements IResourceIO {
    private static final Logger log = LoggerFactory.getLogger(SpringResourceIO.class);
    private String rootResourcePath;
    private ResourceLoader resourceLoader;
    private List<String> ignoreResourcePaths;
    private List<String> ignoreResourceFullPathPatterns;

    public SpringResourceIO(String rootResourcePath, ResourceLoader resourceLoader, List<String> ignoreResourcePaths, List<String> ignoreResourceFullPathPatterns) {
        this.rootResourcePath = rootResourcePath;
        this.resourceLoader = resourceLoader;
        this.ignoreResourcePaths = ignoreResourcePaths;
        this.ignoreResourceFullPathPatterns = ignoreResourceFullPathPatterns;
        log.info("Spring \u8d44\u6e90\u8bfb\u5199: instance=[{}], rootResourcePath='{}', ignoreResourcePaths='{}', ignoreResourceFullPathPatterns='{}'.", new Object[]{this.getInstanceId(), rootResourcePath, ignoreResourcePaths, ignoreResourceFullPathPatterns});
    }

    private void lazyValidate() {
        if (StringUtils.isBlank((CharSequence)this.rootResourcePath)) {
            throw new UnsupportedOperationException("Field 'rootResourcePath' is not invalid.");
        }
        if (null == this.resourceLoader) {
            throw new UnsupportedOperationException("Field 'resourceLoader' is null.");
        }
    }

    public List<String> list() throws IOException {
        this.lazyValidate();
        Resource root = this.resourceLoader.getResource(this.rootResourcePath);
        String rootPath = root.getURL().getPath();
        String pattern = this._fullPath("/**/*.*");
        ResourcePatternResolver patternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        Resource[] resources = patternResolver.getResources(pattern);
        ArrayList<String> result = new ArrayList<String>();
        for (Resource r : resources) {
            String path = r.getURL().getPath();
            path = URLPathUtils.relativizeOf(path, rootPath);
            result.add(path);
        }
        return result;
    }

    private boolean isSkip(String resource) {
        if (null == resource) {
            return true;
        }
        if (null != this.ignoreResourcePaths) {
            for (String pattern : this.ignoreResourcePaths) {
                if (!Wildcard.matchPath((String)resource, (String)pattern)) continue;
                log.info("[{}]: \u5ffd\u7565\u8d44\u6e90 '{}' (\u5339\u914d '{}') .", new Object[]{this.getInstanceId(), resource, pattern});
                return true;
            }
        }
        if (null != this.ignoreResourceFullPathPatterns) {
            String fullPath = this._fullPath(resource);
            for (String pattern : this.ignoreResourceFullPathPatterns) {
                if (!Wildcard.matchPath((String)fullPath, (String)pattern)) continue;
                log.info("[{}]: \u5ffd\u7565\u8d44\u6e90 '{}' (\u5339\u914d Path Wildcard '{}') .", new Object[]{this.getInstanceId(), fullPath, pattern});
                return true;
            }
        }
        return false;
    }

    private String _fullPath(String resource) {
        String fullPath = URLPathUtils.get(this.rootResourcePath, resource);
        return fullPath;
    }

    private Resource getResource(String resource) {
        if (this.isSkip(resource)) {
            return null;
        }
        String resPath = this._fullPath(resource);
        Resource res = this.resourceLoader.getResource(resPath);
        return res;
    }

    public byte[] read(String resource) throws IOException {
        this.lazyValidate();
        Resource res = this.getResource(resource);
        if (null != res && res.exists()) {
            try (InputStream is = res.getInputStream();){
                byte[] byArray = IOUtils.toByteArray((InputStream)is);
                return byArray;
            }
        }
        return null;
    }

    public void write(String resource, byte[] data) throws IOException {
        this.lazyValidate();
        Resource res = this.getResource(resource);
        if (null == res) {
            throw new UnsupportedOperationException("[" + this.getInstanceId() + "]: Can't get resource '" + resource + "' to write.");
        }
        if (!res.isFile()) {
            throw new UnsupportedOperationException("[" + this.getInstanceId() + "]: Writing resource '" + resource + "' is not supported because of it's not File.");
        }
        File f = res.getFile();
        FileUtils.writeByteArrayToFile((File)f, (byte[])data);
    }

    public URI getURI(String resource) throws IOException {
        this.lazyValidate();
        Resource res = this.getResource(resource);
        if (null == res) {
            return null;
        }
        return res.getURI();
    }

    public String getInstanceId() {
        return this.rootResourcePath + "@" + Integer.toHexString(this.hashCode());
    }
}

